/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.utilities;

import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.ControlFlowRegistry;
import kieker.monitoring.core.registry.SessionRegistry;
import kieker.monitoring.probe.utilities.FullOperationStartData;
import kieker.monitoring.timer.ITimeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OperationExecutionDataGatherer {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationExecutionDataGatherer.class);
    private static final IMonitoringController CTRLINST = MonitoringController.getInstance();
    private static final ITimeSource TIME = CTRLINST.getTimeSource();
    private static final String VMNAME = CTRLINST.getHostname();
    private static final ControlFlowRegistry CFREGISTRY = ControlFlowRegistry.INSTANCE;
    private static final SessionRegistry SESSIONREGISTRY = SessionRegistry.INSTANCE;

    public static FullOperationStartData operationStart(String operationSignature) {
        int ess;
        int eoi;
        boolean entrypoint;
        if (!CTRLINST.isMonitoringEnabled()) {
            return null;
        }
        if (!CTRLINST.isProbeActivated(operationSignature)) {
            return null;
        }
        long traceId = CFREGISTRY.recallThreadLocalTraceId();
        if (traceId == -1L) {
            entrypoint = true;
            traceId = CFREGISTRY.getAndStoreUniqueThreadLocalTraceId();
            CFREGISTRY.storeThreadLocalEOI(0);
            CFREGISTRY.storeThreadLocalESS(1);
            eoi = 0;
            ess = 0;
        } else {
            entrypoint = false;
            eoi = CFREGISTRY.incrementAndRecallThreadLocalEOI();
            ess = CFREGISTRY.recallAndIncrementThreadLocalESS();
            if (eoi == -1 || ess == -1) {
                LOGGER.error("eoi and/or ess have invalid values: eoi == {} ess == {}", (Object)eoi, (Object)ess);
                CTRLINST.terminateMonitoring();
            }
        }
        long tin = TIME.getTime();
        return new FullOperationStartData(entrypoint, traceId, tin, eoi, ess, operationSignature);
    }

    public static void operationEnd(FullOperationStartData startData) {
        if (!CTRLINST.isMonitoringEnabled()) {
            return;
        }
        if (!CTRLINST.isProbeActivated(startData.getOperationSignature())) {
            return;
        }
        long tout = TIME.getTime();
        String sessionId = SESSIONREGISTRY.recallThreadLocalSessionId();
        OperationExecutionRecord record = new OperationExecutionRecord(startData.getOperationSignature(), sessionId, startData.getTraceId(), startData.getTin(), tout, VMNAME, startData.getEoi(), startData.getEss());
        CTRLINST.newMonitoringRecord(record);
        if (startData.isEntrypoint()) {
            CFREGISTRY.unsetThreadLocalTraceId();
            CFREGISTRY.unsetThreadLocalEOI();
            CFREGISTRY.unsetThreadLocalESS();
        } else {
            CFREGISTRY.storeThreadLocalESS(startData.getEss());
        }
    }
}

