/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.sampler.oshi.samplers;

import kieker.common.record.system.MemSwapUsageRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.signaturePattern.SignatureFactory;
import kieker.monitoring.sampler.oshi.samplers.AbstractOshiSampler;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;

public class MemSwapUsageSampler
extends AbstractOshiSampler {
    public MemSwapUsageSampler(HardwareAbstractionLayer hardwareAbstractionLayer) {
        super(hardwareAbstractionLayer);
    }

    @Override
    public void sample(IMonitoringController monitoringCtr) {
        if (!monitoringCtr.isMonitoringEnabled() || !monitoringCtr.isProbeActivated(SignatureFactory.createMemSwapSignature())) {
            return;
        }
        GlobalMemory globalMemory = this.hardwareAbstractionLayer.getMemory();
        long memoryTotal = globalMemory.getTotal();
        long memoryAvailable = globalMemory.getAvailable();
        long memoryUsed = memoryTotal - memoryAvailable;
        long swapTotal = globalMemory.getVirtualMemory().getSwapTotal();
        long swapUsed = globalMemory.getVirtualMemory().getSwapUsed();
        long swapFree = swapTotal - swapUsed;
        MemSwapUsageRecord r = new MemSwapUsageRecord(monitoringCtr.getTimeSource().getTime(), monitoringCtr.getHostname(), memoryTotal, memoryUsed, memoryAvailable, swapTotal, swapUsed, swapFree);
        monitoringCtr.newMonitoringRecord(r);
    }
}

