/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.timer;

import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kieker.common.configuration.Configuration;
import kieker.monitoring.timer.AbstractTimeSource;

public final class SystemMilliTimer
extends AbstractTimeSource {
    public static final String CONFIG_OFFSET = SystemMilliTimer.class.getName() + ".offset";
    public static final String CONFIG_UNIT = SystemMilliTimer.class.getName() + ".unit";
    private final long offset;
    private final TimeUnit timeunit;

    public SystemMilliTimer(Configuration configuration) {
        super(configuration);
        this.offset = configuration.getStringProperty(CONFIG_OFFSET).length() == 0 ? System.currentTimeMillis() : configuration.getLongProperty(CONFIG_OFFSET);
        this.timeunit = configuration.getEnumProperty(CONFIG_UNIT, TimeUnit.class, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getTime() {
        return this.timeunit.convert(System.currentTimeMillis() - this.offset, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getOffset() {
        return this.timeunit.convert(this.offset, TimeUnit.MILLISECONDS);
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this.timeunit;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Time in ").append(this.timeunit.toString().toLowerCase(Locale.ENGLISH)).append(" (with milliseconds precision) since ").append(new Date(this.offset));
        return sb.toString();
    }
}

