/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.common;

import com.beust.jcommander.JCommander;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import kieker.common.configuration.Configuration;
import kieker.common.util.classpath.InstantiationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParameterEvaluationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterEvaluationUtils.class);

    private ParameterEvaluationUtils() {
    }

    public static boolean checkDirectory(File location, String label, JCommander commander) {
        if (location == null) {
            LOGGER.error("{} path not specified.", (Object)label);
            commander.usage();
            return false;
        }
        try {
            if (!location.exists()) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("{} path {} does not exist.", (Object)label, (Object)location.getCanonicalPath());
                }
                commander.usage();
                return false;
            }
            if (!location.isDirectory()) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("{} path {} is not a directory.", (Object)label, (Object)location.getCanonicalPath());
                }
                commander.usage();
                return false;
            }
            return true;
        }
        catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("{} path {} cannot be checked. Cause {}", new Object[]{label, location, e.getLocalizedMessage()});
            }
            return false;
        }
    }

    public static boolean isFileReadable(File file, String label, JCommander commander) {
        if (file == null) {
            LOGGER.error("{} path not specified.", (Object)label);
            commander.usage();
            return false;
        }
        try {
            if (!file.exists()) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("{} {} does not exist.", (Object)label, (Object)file.getCanonicalPath());
                }
                return false;
            }
            if (!file.isFile()) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("{} {} is not a file.", (Object)label, (Object)file.getCanonicalPath());
                }
                return false;
            }
            if (!file.canRead()) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("{} {} cannot be read.", (Object)label, (Object)file.getCanonicalPath());
                }
                return false;
            }
            return true;
        }
        catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("{} {} cannot be checked. Cause {}", new Object[]{label, file, e.getLocalizedMessage()});
            }
            return false;
        }
    }

    public static URL createURL(String urlString, String label) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            LOGGER.error("{} Malformend URL {}", (Object)label, (Object)urlString);
            return null;
        }
    }

    public static <T> T createFromConfiguration(Class<T> clazz, Configuration configuration, String key, String errorMessage) {
        String className = configuration.getStringProperty(key);
        if (className.isEmpty()) {
            LOGGER.error("Initialization incomplete: {}", (Object)errorMessage);
            return null;
        }
        return InstantiationFactory.getInstance(configuration).create(clazz, className, null, new Object[0]);
    }
}

