/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.settings.converters;

import com.beust.jcommander.converters.BaseConverter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateConverter
extends BaseConverter<Long> {
    public static final String DATE_FORMAT_PATTERN = "yyyyMMdd'-'HHmmss";
    public static final String HUMAN_READABLE_DATE_FORMAT = "yyyyMMdd'-'HHmmss".replaceAll("'", "") + " | timestamp";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd'-'HHmmss", Locale.US);

    public DateConverter(String optionName) {
        super(optionName);
    }

    public Long convert(String value) {
        long result;
        try {
            result = Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            try {
                Date ignoreBeforeDate = DATE_FORMAT.parse(value);
                result = ignoreBeforeDate.getTime() * 1000000L;
            }
            catch (ParseException ex2) {
                return null;
            }
        }
        return result;
    }

    protected String getErrorString(String value, String to) {
        return "\"" + this.getOptionName() + "\": couldn't convert \"" + value + "\" to timestamp; use yyyyMMdd-HHmmss or timestamp integer";
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

