/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.trace.analysis.filter;

import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.util.signature.Signature;
import kieker.tools.trace.analysis.systemModel.AllocationComponent;
import kieker.tools.trace.analysis.systemModel.AssemblyComponent;
import kieker.tools.trace.analysis.systemModel.ComponentType;
import kieker.tools.trace.analysis.systemModel.Execution;
import kieker.tools.trace.analysis.systemModel.ExecutionContainer;
import kieker.tools.trace.analysis.systemModel.Operation;
import kieker.tools.trace.analysis.systemModel.repository.SystemModelRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Plugin(repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)})
public abstract class AbstractTraceAnalysisFilter
extends AbstractFilterPlugin {
    public static final String CONFIG_PROPERTY_VALUE_VERBOSE = "false";
    public static final String REPOSITORY_PORT_NAME_SYSTEM_MODEL = "systemModelRepository";
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractTraceAnalysisFilter.class);
    private volatile SystemModelRepository systemEntityFactory;

    public AbstractTraceAnalysisFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
    }

    @Override
    public Configuration getCurrentConfiguration() {
        return new Configuration();
    }

    public static final Execution createExecutionByEntityNames(SystemModelRepository systemModelRepository, String executionContainerName, String assemblyComponentTypeName, String componentTypeName, Signature operationSignature, long traceId, String sessionId, int eoi, int ess, long tin, long tout, boolean assumed) {
        Operation op;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("static createExecutionByEntityNames executionContainerName={} assemblyComponentTypeName={} componentTypeName={} operationSignature={} traceId={} sessionId={} eoi={} ess={} tin={} tout={} assumed={}", new Object[]{executionContainerName, assemblyComponentTypeName, componentTypeName, operationSignature, traceId, sessionId, eoi, ess, tin, tout, assumed ? "true" : CONFIG_PROPERTY_VALUE_VERBOSE});
        }
        String allocationComponentName = executionContainerName + "::" + assemblyComponentTypeName;
        String operationFactoryName = componentTypeName + '.' + operationSignature;
        AllocationComponent allocInst = systemModelRepository.getAllocationFactory().lookupAllocationComponentInstanceByNamedIdentifier(allocationComponentName);
        if (allocInst == null) {
            ExecutionContainer execContainer;
            AssemblyComponent assemblyComponent = systemModelRepository.getAssemblyFactory().lookupAssemblyComponentInstanceByNamedIdentifier(assemblyComponentTypeName);
            if (assemblyComponent == null) {
                ComponentType componentType = systemModelRepository.getTypeRepositoryFactory().lookupComponentTypeByNamedIdentifier(assemblyComponentTypeName);
                if (componentType == null) {
                    componentType = systemModelRepository.getTypeRepositoryFactory().createAndRegisterComponentType(assemblyComponentTypeName, assemblyComponentTypeName);
                }
                assemblyComponent = systemModelRepository.getAssemblyFactory().createAndRegisterAssemblyComponentInstance(assemblyComponentTypeName, componentType);
            }
            if ((execContainer = systemModelRepository.getExecutionEnvironmentFactory().lookupExecutionContainerByNamedIdentifier(executionContainerName)) == null) {
                execContainer = systemModelRepository.getExecutionEnvironmentFactory().createAndRegisterExecutionContainer(executionContainerName, executionContainerName);
            }
            allocInst = systemModelRepository.getAllocationFactory().createAndRegisterAllocationComponentInstance(allocationComponentName, assemblyComponent, execContainer);
        }
        if ((op = systemModelRepository.getOperationFactory().lookupOperationByNamedIdentifier(operationFactoryName)) == null) {
            op = systemModelRepository.getOperationFactory().createAndRegisterOperation(operationFactoryName, allocInst.getAssemblyComponent().getType(), operationSignature);
            allocInst.getAssemblyComponent().getType().addOperation(op);
        }
        return new Execution(op, allocInst, traceId, sessionId, eoi, ess, tin, tout, assumed);
    }

    public static final Execution createExecutionByEntityNames(SystemModelRepository systemModelRepository, String executionContainerName, String assemblyComponentTypeName, Signature operationSignature, long traceId, String sessionId, int eoi, int ess, long tin, long tout, boolean assumed) {
        return AbstractTraceAnalysisFilter.createExecutionByEntityNames(systemModelRepository, executionContainerName, assemblyComponentTypeName, assemblyComponentTypeName, operationSignature, traceId, sessionId, eoi, ess, tin, tout, assumed);
    }

    protected final Execution createExecutionByEntityNames(String executionContainerName, String assemblyComponentTypeName, Signature operationSignature, long traceId, String sessionId, int eoi, int ess, long tin, long tout, boolean assumed) {
        return AbstractTraceAnalysisFilter.createExecutionByEntityNames(this.getSystemEntityFactory(), executionContainerName, assemblyComponentTypeName, assemblyComponentTypeName, operationSignature, traceId, sessionId, eoi, ess, tin, tout, assumed);
    }

    protected void printDebugLogMessage(String[] lines) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("");
            LOGGER.debug("#");
            LOGGER.debug("# Plugin: " + this.getClass().getName());
            for (String l : lines) {
                LOGGER.debug(l);
            }
        }
    }

    protected void printErrorLogMessage(String[] lines) {
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error("");
            LOGGER.error("#");
            LOGGER.error("# Plugin: " + this.getClass().getName());
            for (String l : lines) {
                LOGGER.error(l);
            }
        }
    }

    public final SystemModelRepository getSystemEntityFactory() {
        if (this.systemEntityFactory == null) {
            this.systemEntityFactory = (SystemModelRepository)this.getRepository(REPOSITORY_PORT_NAME_SYSTEM_MODEL);
        }
        if (this.systemEntityFactory == null) {
            LOGGER.error("Failed to connect to system model repository via repository port '{}' (not connected?)", (Object)REPOSITORY_PORT_NAME_SYSTEM_MODEL);
        }
        return this.systemEntityFactory;
    }
}

