/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.trace.analysis.filter.traceReconstruction;

import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import kieker.analysis.IProjectContext;
import kieker.analysis.architecture.trace.execution.ExecutionEventProcessingException;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.common.configuration.Configuration;
import kieker.common.util.dataformat.LoggingTimestampConversionUtils;
import kieker.tools.trace.analysis.filter.AbstractTraceProcessingFilter;
import kieker.tools.trace.analysis.filter.traceReconstruction.InvalidTraceException;
import kieker.tools.trace.analysis.systemModel.Execution;
import kieker.tools.trace.analysis.systemModel.ExecutionTrace;
import kieker.tools.trace.analysis.systemModel.InvalidExecutionTrace;
import kieker.tools.trace.analysis.systemModel.MessageTrace;
import kieker.tools.trace.analysis.systemModel.repository.SystemModelRepository;

@Deprecated
@Plugin(description="Uses the incoming data to enrich the connected repository with the reconstructed traces", outputPorts={@OutputPort(name="messageTraces", description="Reconstructed Message Traces", eventTypes={MessageTrace.class}), @OutputPort(name="executionTraces", description="Reconstructed Execution Traces", eventTypes={ExecutionTrace.class}), @OutputPort(name="invalidExecutionTraces", description="Invalid Execution Traces", eventTypes={InvalidExecutionTrace.class})}, repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)}, configuration={@Property(name="timeunit", defaultValue="NANOSECONDS"), @Property(name="maxTraceDuration", defaultValue="9223372036854775807"), @Property(name="ignoreInvalidTraces", defaultValue="true")})
public class TraceReconstructionFilter
extends AbstractTraceProcessingFilter {
    public static final String INPUT_PORT_NAME_EXECUTIONS = "executions";
    public static final String OUTPUT_PORT_NAME_MESSAGE_TRACE = "messageTraces";
    public static final String OUTPUT_PORT_NAME_EXECUTION_TRACE = "executionTraces";
    public static final String OUTPUT_PORT_NAME_INVALID_EXECUTION_TRACE = "invalidExecutionTraces";
    public static final String CONFIG_PROPERTY_NAME_TIMEUNIT = "timeunit";
    public static final String CONFIG_PROPERTY_NAME_MAX_TRACE_DURATION = "maxTraceDuration";
    public static final String CONFIG_PROPERTY_NAME_IGNORE_INVALID_TRACES = "ignoreInvalidTraces";
    public static final String CONFIG_PROPERTY_VALUE_TIMEUNIT = "NANOSECONDS";
    public static final String CONFIG_PROPERTY_VALUE_MAX_TRACE_DURATION = "9223372036854775807";
    private final TimeUnit timeunit;
    private final Map<Long, ExecutionTrace> pendingTraces = new Hashtable<Long, ExecutionTrace>();
    private final Set<Long> invalidTraces = new TreeSet<Long>();
    private volatile long minTin = -1L;
    private volatile long maxTout = -1L;
    private volatile boolean terminated;
    private final boolean ignoreInvalidTraces;
    private final long maxTraceDuration;
    private boolean traceProcessingErrorOccured;
    private final NavigableSet<ExecutionTrace> timeoutMap = new TreeSet<ExecutionTrace>(new Comparator<ExecutionTrace>(){

        @Override
        public int compare(ExecutionTrace t1, ExecutionTrace t2) {
            long t2LowestTin;
            if (t1 == t2) {
                return 0;
            }
            long t1LowestTin = t1.getTraceAsSortedExecutionSet().first().getTin();
            if (t1LowestTin != (t2LowestTin = t2.getTraceAsSortedExecutionSet().first().getTin())) {
                return t1LowestTin < t2LowestTin ? -1 : 1;
            }
            return t1.getTraceId() < t2.getTraceId() ? -1 : 1;
        }
    });

    public TraceReconstructionFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        TimeUnit configTimeunit;
        this.timeunit = this.recordsTimeUnitFromProjectContext;
        String configTimeunitProperty = configuration.getStringProperty(CONFIG_PROPERTY_NAME_TIMEUNIT);
        try {
            configTimeunit = TimeUnit.valueOf(configTimeunitProperty);
        }
        catch (IllegalArgumentException ex) {
            this.logger.warn("{} is no valid TimeUnit! Using inherited value of {} instead.", (Object)configTimeunitProperty, (Object)this.timeunit.name());
            configTimeunit = this.timeunit;
        }
        this.maxTraceDuration = this.timeunit.convert(configuration.getLongProperty(CONFIG_PROPERTY_NAME_MAX_TRACE_DURATION), configTimeunit);
        this.ignoreInvalidTraces = configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_IGNORE_INVALID_TRACES);
        if (this.maxTraceDuration < 0L) {
            throw new IllegalArgumentException("value maxTraceDurationMillis must not be negative (found: " + this.maxTraceDuration + ")");
        }
    }

    public Set<Long> getInvalidTraces() {
        return this.invalidTraces;
    }

    public final long getMinTin() {
        return this.minTin;
    }

    public final long getMaxTout() {
        return this.maxTout;
    }

    @Override
    public boolean init() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InputPort(name="executions", description="Receives the executions to be processed", eventTypes={Execution.class})
    public void inputExecutions(Execution execution) {
        TraceReconstructionFilter traceReconstructionFilter = this;
        synchronized (traceReconstructionFilter) {
            if (this.terminated || this.traceProcessingErrorOccured && !this.ignoreInvalidTraces) {
                return;
            }
            long traceId = execution.getTraceId();
            this.minTin = this.minTin < 0L || execution.getTin() < this.minTin ? execution.getTin() : this.minTin;
            this.maxTout = execution.getTout() > this.maxTout ? execution.getTout() : this.maxTout;
            ExecutionTrace executionTrace = this.pendingTraces.get(traceId);
            if (executionTrace != null) {
                if (!this.timeoutMap.remove(executionTrace)) {
                    this.logger.error("Missing entry for trace in timeoutMap: {} PendingTraces and timeoutMap are now longer consistent!", (Object)executionTrace);
                    this.reportError(traceId);
                }
            } else {
                executionTrace = new ExecutionTrace(traceId, execution.getSessionId());
                this.pendingTraces.put(traceId, executionTrace);
            }
            try {
                executionTrace.add(execution);
                if (!this.timeoutMap.add(executionTrace)) {
                    this.logger.error("Equal entry existed in timeoutMap already: {}", (Object)executionTrace);
                }
                this.processTimeoutQueue();
            }
            catch (InvalidTraceException ex) {
                this.logger.error("Attempt to add record to wrong trace", (Throwable)ex);
            }
            catch (ExecutionEventProcessingException ex) {
                this.logger.error("ExecutionEventProcessingException occured while processing the timeout queue.", (Throwable)ex);
            }
        }
    }

    private void processExecutionTrace(ExecutionTrace executionTrace) throws ExecutionEventProcessingException {
        long curTraceId = executionTrace.getTraceId();
        try {
            MessageTrace messageTrace = executionTrace.toMessageTrace(SystemModelRepository.ROOT_EXECUTION);
            if (!this.invalidTraces.contains(messageTrace.getTraceId())) {
                super.deliver(OUTPUT_PORT_NAME_MESSAGE_TRACE, messageTrace);
                super.deliver(OUTPUT_PORT_NAME_EXECUTION_TRACE, executionTrace);
                this.reportSuccess(curTraceId);
            } else {
                super.deliver(OUTPUT_PORT_NAME_INVALID_EXECUTION_TRACE, new InvalidExecutionTrace(executionTrace));
            }
        }
        catch (InvalidTraceException ex) {
            super.deliver(OUTPUT_PORT_NAME_INVALID_EXECUTION_TRACE, new InvalidExecutionTrace(executionTrace));
            String transformationError = "Failed to transform execution trace to message trace (ID: " + curTraceId + "). \nReason: " + ex.getMessage() + "\n Trace: " + executionTrace;
            if (!this.invalidTraces.contains(curTraceId)) {
                this.reportError(curTraceId);
                this.invalidTraces.add(curTraceId);
                if (!this.ignoreInvalidTraces) {
                    this.traceProcessingErrorOccured = true;
                    this.logger.warn("Note that this filter was configured to terminate at the *first* occurence of an invalid trace \nIf this is not the desired behavior, set the configuration property {} to 'true'", (Object)CONFIG_PROPERTY_NAME_IGNORE_INVALID_TRACES);
                    throw new ExecutionEventProcessingException(transformationError, ex);
                }
                this.logger.error(transformationError);
            }
            this.logger.warn("Found additional fragment for trace already marked invalid: {}", (Object)transformationError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTimeoutQueue() throws ExecutionEventProcessingException {
        NavigableSet<ExecutionTrace> navigableSet = this.timeoutMap;
        synchronized (navigableSet) {
            while (!this.timeoutMap.isEmpty() && (this.terminated || this.maxTout - ((ExecutionTrace)this.timeoutMap.first()).getMinTin() > this.maxTraceDuration)) {
                ExecutionTrace polledTrace = this.timeoutMap.pollFirst();
                long curTraceId = polledTrace.getTraceId();
                this.pendingTraces.remove(curTraceId);
                this.processExecutionTrace(polledTrace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getMaxTraceDuration() {
        TraceReconstructionFilter traceReconstructionFilter = this;
        synchronized (traceReconstructionFilter) {
            return this.maxTraceDuration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate(boolean error) {
        TraceReconstructionFilter traceReconstructionFilter = this;
        synchronized (traceReconstructionFilter) {
            try {
                this.terminated = true;
                if (!error || this.traceProcessingErrorOccured && !this.ignoreInvalidTraces) {
                    this.processTimeoutQueue();
                } else {
                    this.logger.info("Terminate called with error an flag set or a trace processing occurred; won't process timeoutqueue any more.");
                }
            }
            catch (ExecutionEventProcessingException ex) {
                this.traceProcessingErrorOccured = true;
                this.logger.error("Error processing timeout queue", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStatusMessage() {
        TraceReconstructionFilter traceReconstructionFilter = this;
        synchronized (traceReconstructionFilter) {
            super.printStatusMessage();
            if (this.getSuccessCount() > 0 || this.getErrorCount() > 0) {
                String minTinStr = this.minTin + " (" + LoggingTimestampConversionUtils.convertLoggingTimestampToUTCString(this.timeunit.toNanos(this.minTin)) + ',' + LoggingTimestampConversionUtils.convertLoggingTimestampLocalTimeZoneString(this.minTin) + ')';
                String maxToutStr = this.maxTout + " (" + LoggingTimestampConversionUtils.convertLoggingTimestampToUTCString(this.timeunit.toNanos(this.maxTout)) + ',' + LoggingTimestampConversionUtils.convertLoggingTimestampLocalTimeZoneString(this.maxTout) + ')';
                LOGGER.debug("First timestamp: {}", (Object)minTinStr);
                LOGGER.debug("Last timestamp: {}", (Object)maxToutStr);
            }
        }
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = super.getCurrentConfiguration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_TIMEUNIT, this.timeunit.name());
        configuration.setProperty(CONFIG_PROPERTY_NAME_MAX_TRACE_DURATION, Long.toString(this.maxTraceDuration));
        configuration.setProperty(CONFIG_PROPERTY_NAME_IGNORE_INVALID_TRACES, Boolean.toString(this.ignoreInvalidTraces));
        return configuration;
    }
}

