/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.trace.analysis.filter.visualization;

import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.tools.trace.analysis.filter.visualization.AbstractGraphFormatter;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.ComponentAllocationDependencyGraph;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.ComponentAllocationDependencyGraphFormatter;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.ComponentAssemblyDependencyGraph;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.ComponentAssemblyDependencyGraphFormatter;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.ContainerDependencyGraph;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.ContainerDependencyGraphFormatter;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.OperationAllocationDependencyGraph;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.OperationAllocationDependencyGraphFormatter;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.OperationAssemblyDependencyGraph;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.OperationAssemblyDependencyGraphFormatter;
import kieker.tools.trace.analysis.filter.visualization.exception.GraphFormattingException;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractGraph;

@Deprecated
@Plugin(name="Graph writer plugin", description="Generic plugin for writing graphs to files", configuration={@Property(name="includeWeights", defaultValue="true"), @Property(name="shortLabels", defaultValue="true"), @Property(name="selfLoops", defaultValue="false")})
public class GraphWriterPlugin
extends AbstractFilterPlugin {
    public static final String CONFIG_PROPERTY_NAME_OUTPUT_FILE_NAME = "dotOutputFn";
    public static final String CONFIG_PROPERTY_NAME_OUTPUT_PATH_NAME = "outputPath";
    public static final String CONFIG_PROPERTY_NAME_INCLUDE_WEIGHTS = "includeWeights";
    public static final String CONFIG_PROPERTY_NAME_SHORTLABELS = "shortLabels";
    public static final String CONFIG_PROPERTY_NAME_SELFLOOPS = "selfLoops";
    public static final String INPUT_PORT_NAME_GRAPHS = "inputGraph";
    private static final String NO_SUITABLE_FORMATTER_MESSAGE_TEMPLATE = "No formatter type defined for graph type %s.";
    private static final String INSTANTIATION_ERROR_MESSAGE_TEMPLATE = "Could not instantiate formatter type %s for graph type %s.";
    private static final String WRITE_ERROR_MESSAGE_TEMPLATE = "Graph could not be written to file %s.";
    private static final ConcurrentMap<Class<? extends AbstractGraph<?, ?, ?>>, Class<? extends AbstractGraphFormatter<?>>> FORMATTER_REGISTRY = new ConcurrentHashMap();
    private final String outputPathName;
    private final String outputFileName;
    private final boolean includeWeights;
    private final boolean useShortLabels;
    private final boolean plotLoops;

    public GraphWriterPlugin(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        this.outputPathName = configuration.getPathProperty(CONFIG_PROPERTY_NAME_OUTPUT_PATH_NAME);
        this.outputFileName = configuration.getPathProperty(CONFIG_PROPERTY_NAME_OUTPUT_FILE_NAME);
        this.includeWeights = configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_INCLUDE_WEIGHTS);
        this.useShortLabels = configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_SHORTLABELS);
        this.plotLoops = configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_SELFLOOPS);
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_OUTPUT_PATH_NAME, this.outputPathName);
        configuration.setProperty(CONFIG_PROPERTY_NAME_OUTPUT_FILE_NAME, this.outputFileName);
        configuration.setProperty(CONFIG_PROPERTY_NAME_INCLUDE_WEIGHTS, String.valueOf(this.includeWeights));
        configuration.setProperty(CONFIG_PROPERTY_NAME_SHORTLABELS, String.valueOf(this.useShortLabels));
        configuration.setProperty(CONFIG_PROPERTY_NAME_SELFLOOPS, String.valueOf(this.plotLoops));
        return configuration;
    }

    private static void handleInstantiationException(Class<?> graphClass, Class<?> formatterClass, Exception exception) {
        throw new GraphFormattingException(String.format(INSTANTIATION_ERROR_MESSAGE_TEMPLATE, formatterClass.getName(), graphClass.getName()), exception);
    }

    private static AbstractGraphFormatter<?> createFormatter(AbstractGraph<?, ?, ?> graph) {
        Class formatterClass = (Class)FORMATTER_REGISTRY.get(graph.getClass());
        if (formatterClass == null) {
            throw new GraphFormattingException(String.format(NO_SUITABLE_FORMATTER_MESSAGE_TEMPLATE, graph.getClass().getName()));
        }
        try {
            Constructor constructor = formatterClass.getConstructor(new Class[0]);
            return (AbstractGraphFormatter)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            GraphWriterPlugin.handleInstantiationException(graph.getClass(), formatterClass, e);
            return null;
        }
    }

    private String getOutputFileName(AbstractGraphFormatter<?> formatter) {
        if (this.outputFileName.length() == 0) {
            return formatter.getDefaultFileName();
        }
        return this.outputFileName;
    }

    @InputPort(name="inputGraph", eventTypes={AbstractGraph.class})
    public void writeGraph(AbstractGraph<?, ?, ?> graph) {
        AbstractGraphFormatter<?> graphFormatter = GraphWriterPlugin.createFormatter(graph);
        String specification = graphFormatter.createFormattedRepresentation(graph, this.includeWeights, this.useShortLabels, this.plotLoops);
        String fileName = this.outputPathName + this.getOutputFileName(graphFormatter);
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(fileName, new String[0]), new OpenOption[0]);){
            writer.write(specification);
            writer.flush();
        }
        catch (IOException e) {
            throw new GraphFormattingException(String.format(WRITE_ERROR_MESSAGE_TEMPLATE, fileName), e);
        }
    }

    static {
        FORMATTER_REGISTRY.put(ComponentAllocationDependencyGraph.class, ComponentAllocationDependencyGraphFormatter.class);
        FORMATTER_REGISTRY.put(ComponentAssemblyDependencyGraph.class, ComponentAssemblyDependencyGraphFormatter.class);
        FORMATTER_REGISTRY.put(OperationAllocationDependencyGraph.class, OperationAllocationDependencyGraphFormatter.class);
        FORMATTER_REGISTRY.put(OperationAssemblyDependencyGraph.class, OperationAssemblyDependencyGraphFormatter.class);
        FORMATTER_REGISTRY.put(ContainerDependencyGraph.class, ContainerDependencyGraphFormatter.class);
    }
}

