/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.trace.analysis.filter.visualization.callTree;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.common.configuration.Configuration;
import kieker.tools.trace.analysis.filter.AbstractMessageTraceProcessingFilter;
import kieker.tools.trace.analysis.filter.traceReconstruction.TraceProcessingException;
import kieker.tools.trace.analysis.filter.visualization.callTree.AbstractCallTreeFilter;
import kieker.tools.trace.analysis.filter.visualization.callTree.TraceCallTreeNode;
import kieker.tools.trace.analysis.filter.visualization.graph.IOriginRetentionPolicy;
import kieker.tools.trace.analysis.filter.visualization.graph.NoOriginRetentionPolicy;
import kieker.tools.trace.analysis.systemModel.AllocationComponent;
import kieker.tools.trace.analysis.systemModel.MessageTrace;
import kieker.tools.trace.analysis.systemModel.Operation;
import kieker.tools.trace.analysis.systemModel.SynchronousCallMessage;
import kieker.tools.trace.analysis.systemModel.repository.AllocationComponentOperationPairFactory;
import kieker.tools.trace.analysis.systemModel.repository.SystemModelRepository;
import kieker.tools.trace.analysis.systemModel.util.AllocationComponentOperationPair;

@Deprecated
@Plugin(description="A filter allowing to write the incoming data into a calling tree", repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)}, configuration={@Property(name="shortLabels", defaultValue="true"), @Property(name="dotOutputFn", defaultValue="traceCalltree.dot")})
public class TraceCallTreeFilter
extends AbstractMessageTraceProcessingFilter {
    public static final String CONFIG_PROPERTY_NAME_OUTPUT_FILENAME = "dotOutputFn";
    public static final String CONFIG_PROPERTY_NAME_SHORT_LABELS = "shortLabels";
    public static final String CONFIG_PROPERTY_VALUE_OUTPUT_FILENAME_DEFAULT = "traceCalltree.dot";
    public static final String CONFIG_PROPERTY_VALUE_SHORT_LABELS_DEFAULT = "true";
    private final String dotOutputFn;
    private final boolean shortLabels;

    public TraceCallTreeFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        this.shortLabels = configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_SHORT_LABELS);
        this.dotOutputFn = configuration.getStringProperty(CONFIG_PROPERTY_NAME_OUTPUT_FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStatusMessage() {
        TraceCallTreeFilter traceCallTreeFilter = this;
        synchronized (traceCallTreeFilter) {
            super.printStatusMessage();
            int numPlots = this.getSuccessCount();
            long lastSuccessTracesId = this.getLastTraceIdSuccess();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Wrote " + numPlots + " call tree" + (numPlots > 1 ? "s" : "") + " to file" + (numPlots > 1 ? "s" : "") + " with name pattern '" + this.dotOutputFn + "-<traceId>.dot'");
                LOGGER.debug("Dot files can be converted using the dot tool");
                LOGGER.debug("Example: dot -T svg " + this.dotOutputFn + "-" + (Serializable)(numPlots > 0 ? Long.valueOf(lastSuccessTracesId) : "<traceId>") + ".dot > " + this.dotOutputFn + "-" + (Serializable)(numPlots > 0 ? Long.valueOf(lastSuccessTracesId) : "<traceId>") + ".svg");
            }
        }
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = super.getCurrentConfiguration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_SHORT_LABELS, Boolean.toString(this.shortLabels));
        configuration.setProperty(CONFIG_PROPERTY_NAME_OUTPUT_FILENAME, this.dotOutputFn);
        return configuration;
    }

    @Override
    @InputPort(name="messageTraces", description="Receives the message traces to be processed", eventTypes={MessageTrace.class})
    public void inputMessageTraces(MessageTrace mt) throws IOException {
        try {
            TraceCallTreeNode rootNode = new TraceCallTreeNode(0, AllocationComponentOperationPairFactory.ROOT_PAIR, true, mt, (IOriginRetentionPolicy)NoOriginRetentionPolicy.createInstance());
            AbstractCallTreeFilter.writeDotForMessageTrace(rootNode, new AbstractCallTreeFilter.IPairFactory<AllocationComponentOperationPair>(){

                @Override
                public AllocationComponentOperationPair createPair(SynchronousCallMessage callMsg) {
                    AllocationComponent allocationComponent = callMsg.getReceivingExecution().getAllocationComponent();
                    Operation op = callMsg.getReceivingExecution().getOperation();
                    return TraceCallTreeFilter.this.getSystemEntityFactory().getAllocationPairFactory().getPairInstanceByPair(allocationComponent, op);
                }
            }, mt, this.dotOutputFn + "-" + mt.getTraceId() + ".dot", false, this.shortLabels);
            this.reportSuccess(mt.getTraceId());
        }
        catch (TraceProcessingException ex) {
            this.reportError(mt.getTraceId());
            this.logger.error("TraceProcessingException", (Throwable)ex);
        }
        catch (FileNotFoundException ex) {
            this.reportError(mt.getTraceId());
            this.logger.error("File not found", (Throwable)ex);
        }
        catch (UnsupportedEncodingException ex) {
            this.reportError(mt.getTraceId());
            this.logger.error("Encoding not supported", (Throwable)ex);
        }
    }
}

