/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.trace.analysis.systemModel.repository;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collection;
import kieker.analysis.IProjectContext;
import kieker.analysis.repository.AbstractRepository;
import kieker.analysis.repository.annotation.Repository;
import kieker.common.configuration.Configuration;
import kieker.tools.trace.analysis.systemModel.AllocationComponent;
import kieker.tools.trace.analysis.systemModel.AssemblyComponent;
import kieker.tools.trace.analysis.systemModel.ComponentType;
import kieker.tools.trace.analysis.systemModel.Execution;
import kieker.tools.trace.analysis.systemModel.ExecutionContainer;
import kieker.tools.trace.analysis.systemModel.Operation;
import kieker.tools.trace.analysis.systemModel.repository.AllocationComponentOperationPairFactory;
import kieker.tools.trace.analysis.systemModel.repository.AllocationRepository;
import kieker.tools.trace.analysis.systemModel.repository.AssemblyComponentOperationPairFactory;
import kieker.tools.trace.analysis.systemModel.repository.AssemblyRepository;
import kieker.tools.trace.analysis.systemModel.repository.ExecutionEnvironmentRepository;
import kieker.tools.trace.analysis.systemModel.repository.OperationRepository;
import kieker.tools.trace.analysis.systemModel.repository.TypeRepository;

@Deprecated
@Repository(name="System model repository", description="Model manager for Kieker's component model ")
public class SystemModelRepository
extends AbstractRepository {
    public static final Execution ROOT_EXECUTION = new Execution(OperationRepository.ROOT_OPERATION, AllocationRepository.ROOT_ALLOCATION_COMPONENT, -1L, "-1", -1, -1, -1L, -1L, false);
    public static final String ROOT_NODE_LABEL = "'Entry'";
    private static final String ENCODING = "UTF-8";
    private final TypeRepository typeRepositoryFactory = new TypeRepository(this);
    private final AssemblyRepository assemblyFactory = new AssemblyRepository(this);
    private final ExecutionEnvironmentRepository executionEnvironmentFactory = new ExecutionEnvironmentRepository(this);
    private final AllocationRepository allocationFactory = new AllocationRepository(this);
    private final OperationRepository operationFactory = new OperationRepository(this);
    private final AllocationComponentOperationPairFactory allocationPairFactory = new AllocationComponentOperationPairFactory(this);
    private final AssemblyComponentOperationPairFactory assemblyPairFactory = new AssemblyComponentOperationPairFactory(this);

    public SystemModelRepository(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
    }

    public final AllocationRepository getAllocationFactory() {
        return this.allocationFactory;
    }

    public final AssemblyRepository getAssemblyFactory() {
        return this.assemblyFactory;
    }

    public final ExecutionEnvironmentRepository getExecutionEnvironmentFactory() {
        return this.executionEnvironmentFactory;
    }

    public final OperationRepository getOperationFactory() {
        return this.operationFactory;
    }

    public final TypeRepository getTypeRepositoryFactory() {
        return this.typeRepositoryFactory;
    }

    public AllocationComponentOperationPairFactory getAllocationPairFactory() {
        return this.allocationPairFactory;
    }

    public AssemblyComponentOperationPairFactory getAssemblyPairFactory() {
        return this.assemblyPairFactory;
    }

    private String htmlEntityLabel(int id, String caption, EntityType entityType) {
        StringBuilder strBuild = new StringBuilder(64);
        strBuild.append("<a name=\"").append(SystemModelRepository.simpleHTMLEscape(entityType.toString())).append('-').append(id).append("\">").append(caption).append("</a>");
        return strBuild.toString();
    }

    private String htmlEntityRef(int id, String caption, EntityType entityType) {
        StringBuilder strBuild = new StringBuilder(64);
        strBuild.append("<a href=\"#").append(SystemModelRepository.simpleHTMLEscape(entityType.toString())).append('-').append(id).append("\">").append(caption).append("</a>");
        return strBuild.toString();
    }

    private void printOpenHtmlTable(PrintStream ps, String title, String[] columnTitle) {
        ps.println("<table class=\"tab\" border=\"1\" style=\"width:100%\">");
        ps.println("<tr><th class=\"tabTitle\" colspan=\"" + columnTitle.length + "\">" + title + "</th></tr>");
        ps.println("<tr>");
        for (String cell : columnTitle) {
            ps.println("<th class=\"colTitle space\">" + cell + "</th>");
        }
        ps.println("</tr>");
    }

    private void printHtmlTableRow(PrintStream ps, String[] cells) {
        ps.println("<tr class=\"cell\">");
        for (String cell : cells) {
            ps.println("<td class=\"space\">" + (cell.length() == 0 ? "&nbsp;" : cell) + "</td>");
        }
        ps.println("</tr>");
    }

    private void printCloseHtmlTable(PrintStream ps) {
        ps.println("</table>");
    }

    private void htmlHSpace(PrintStream ps, int numLines) {
        if (numLines <= 0) {
            return;
        }
        StringBuilder strBuild = new StringBuilder("<pre>\n");
        for (int i = 0; i < numLines; ++i) {
            strBuild.append(".\n");
        }
        strBuild.append("</pre>");
        ps.println(strBuild.toString());
    }

    public void saveSystemToHTMLFile(String outputFn) throws IOException {
        PrintStream ps = new PrintStream(Files.newOutputStream(Paths.get(outputFn, new String[0]), new OpenOption[0]), false, ENCODING);
        ps.println("<html><head><title>System Model Reconstructed by Kieker.TraceAnalysis</title>");
        ps.println("<style type=\"text/css\">\n.colTitle {font-size: 11px; background: linear-gradient(to bottom, #FDFDFD, #DDDDDD) transparent }\n.cell {font-family: monospace; font-size: 10px; font-family: inherited}\n.tabTitle {padding: 4px 4px; font-size: 12px; background: linear-gradient(to bottom, #FFFFFF, #CCEEFF) transparent; border: 1px solid #4DC4FF;color: #333399}\n.tab {border-collapse: collapse;  border: 1px solid #9D9D9D; font-family: \"Segoe UI\", \"Verdana\", \"Arial\", sans-serif}\n.space{padding: 4px 10px;}\n</style>");
        ps.println("</head><body>");
        this.htmlHSpace(ps, 10);
        this.printOpenSurroundingSpan(ps);
        this.printOpenHtmlTable(ps, "Component Types", new String[]{"ID", "Package", "Name", "Operations"});
        Collection<ComponentType> componentTypes = this.typeRepositoryFactory.getComponentTypes();
        for (ComponentType componentType : componentTypes) {
            StringBuilder stringBuilder = new StringBuilder();
            if (componentType.getOperations().size() > 0) {
                for (Operation operation : componentType.getOperations()) {
                    stringBuilder.append("<li>").append(this.htmlEntityRef(operation.getId(), SystemModelRepository.simpleHTMLEscape(operation.getSignature().toString()), EntityType.OPERATION)).append("</li>");
                }
            }
            String[] stringArray = new String[]{this.htmlEntityLabel(componentType.getId(), Integer.toString(componentType.getId()), EntityType.COMPONENT_TYPE), SystemModelRepository.simpleHTMLEscape(componentType.getPackageName()), SystemModelRepository.simpleHTMLEscape(componentType.getTypeName()), stringBuilder.toString()};
            this.printHtmlTableRow(ps, stringArray);
        }
        this.printCloseHtmlTable(ps);
        this.printLinebreak(ps);
        this.printOpenHtmlTable(ps, "Operations", new String[]{"ID", "Component type", "Name", "Parameter types", "Return type"});
        Collection<Operation> operations = this.operationFactory.getOperations();
        for (Operation operation : operations) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String paramType : operation.getSignature().getParamTypeList()) {
                stringBuilder.append("<li>").append(SystemModelRepository.simpleHTMLEscape(paramType)).append("</li>");
            }
            String[] stringArray = new String[]{this.htmlEntityLabel(operation.getId(), Integer.toString(operation.getId()), EntityType.OPERATION), this.htmlEntityRef(operation.getComponentType().getId(), SystemModelRepository.simpleHTMLEscape(operation.getComponentType().getFullQualifiedName()), EntityType.COMPONENT_TYPE), SystemModelRepository.simpleHTMLEscape(operation.getSignature().getName()), stringBuilder.toString(), SystemModelRepository.simpleHTMLEscape(operation.getSignature().getReturnType())};
            this.printHtmlTableRow(ps, stringArray);
        }
        this.printCloseHtmlTable(ps);
        this.printLinebreak(ps);
        this.printOpenHtmlTable(ps, "Assembly Components", new String[]{"ID", "Name", "Component type"});
        Collection<AssemblyComponent> collection = this.assemblyFactory.getAssemblyComponentInstances();
        for (AssemblyComponent assemblyComponent : collection) {
            String[] stringArray = new String[]{this.htmlEntityLabel(assemblyComponent.getId(), Integer.toString(assemblyComponent.getId()), EntityType.ASSEMBLY_COMPONENT), assemblyComponent.getName(), this.htmlEntityRef(assemblyComponent.getType().getId(), SystemModelRepository.simpleHTMLEscape(assemblyComponent.getType().getFullQualifiedName()), EntityType.COMPONENT_TYPE)};
            this.printHtmlTableRow(ps, stringArray);
        }
        this.printCloseHtmlTable(ps);
        this.printLinebreak(ps);
        this.printOpenHtmlTable(ps, "Execution Containers", new String[]{"ID", "Name"});
        Collection<ExecutionContainer> collection2 = this.executionEnvironmentFactory.getExecutionContainers();
        for (ExecutionContainer executionContainer : collection2) {
            String[] cells3 = new String[]{this.htmlEntityLabel(executionContainer.getId(), Integer.toString(executionContainer.getId()), EntityType.EXECUTION_CONTAINER), SystemModelRepository.simpleHTMLEscape(executionContainer.getName())};
            this.printHtmlTableRow(ps, cells3);
        }
        this.printCloseHtmlTable(ps);
        this.printLinebreak(ps);
        this.printOpenHtmlTable(ps, "Deployment Components", new String[]{"ID", "Assembly component", "Execution container"});
        Collection<AllocationComponent> collection3 = this.allocationFactory.getAllocationComponentInstances();
        for (AllocationComponent allocationComponent : collection3) {
            String[] cells4 = new String[]{this.htmlEntityLabel(allocationComponent.getId(), Integer.toString(allocationComponent.getId()), EntityType.ALLOCATION_COMPONENT), this.htmlEntityRef(allocationComponent.getAssemblyComponent().getId(), SystemModelRepository.simpleHTMLEscape(allocationComponent.getAssemblyComponent().toString()), EntityType.ALLOCATION_COMPONENT), this.htmlEntityRef(allocationComponent.getExecutionContainer().getId(), SystemModelRepository.simpleHTMLEscape(allocationComponent.getExecutionContainer().getName()), EntityType.EXECUTION_CONTAINER)};
            this.printHtmlTableRow(ps, cells4);
        }
        this.printCloseHtmlTable(ps);
        this.printCloseSurroundingSpan(ps);
        this.htmlHSpace(ps, 50);
        ps.println("</body></html>");
        ps.flush();
        ps.close();
    }

    private void printOpenSurroundingSpan(PrintStream ps) {
        ps.println("<span style=\"display: inline-block\">");
    }

    private void printCloseSurroundingSpan(PrintStream ps) {
        ps.println("</span>");
    }

    private void printLinebreak(PrintStream ps) {
        ps.println("<br/>");
    }

    private static String simpleHTMLEscape(String input) {
        return input.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#x27;").replace("/", "&#x2F;");
    }

    @Override
    public Configuration getCurrentConfiguration() {
        return new Configuration();
    }

    private static enum EntityType {
        COMPONENT_TYPE,
        OPERATION,
        ASSEMBLY_COMPONENT,
        ALLOCATION_COMPONENT,
        EXECUTION_CONTAINER;

    }
}

