/*
 * Decompiled with CFR 0.152.
 */
package kieker.visualization.trace.dependency.graph;

import java.util.concurrent.TimeUnit;
import kieker.model.repository.ExecutionEnvironmentRepository;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.AbstractMessage;
import kieker.model.system.model.AllocationComponent;
import kieker.model.system.model.ExecutionContainer;
import kieker.model.system.model.MessageTrace;
import kieker.model.system.model.SynchronousReplyMessage;
import kieker.visualization.trace.dependency.graph.AbstractDependencyGraph;
import kieker.visualization.trace.dependency.graph.AbstractDependencyGraphFilter;
import kieker.visualization.trace.dependency.graph.ContainerDependencyGraph;
import kieker.visualization.trace.dependency.graph.DependencyGraphNode;

public class ContainerDependencyGraphFilter
extends AbstractDependencyGraphFilter<ExecutionContainer> {
    public ContainerDependencyGraphFilter(SystemModelRepository repository, TimeUnit timeUnit) {
        super(repository, timeUnit, new ContainerDependencyGraph(ExecutionEnvironmentRepository.ROOT_EXECUTION_CONTAINER));
    }

    @Override
    protected void execute(MessageTrace t) throws Exception {
        for (AbstractMessage m : t.getSequenceAsVector()) {
            if (m instanceof SynchronousReplyMessage) continue;
            AllocationComponent senderComponent = m.getSendingExecution().getAllocationComponent();
            AllocationComponent receiverComponent = m.getReceivingExecution().getAllocationComponent();
            ExecutionContainer senderContainer = senderComponent.getExecutionContainer();
            ExecutionContainer receiverContainer = receiverComponent.getExecutionContainer();
            DependencyGraphNode<Object> senderNode = ((AbstractDependencyGraph)this.getGraph()).getNode(senderContainer.getId());
            DependencyGraphNode<Object> receiverNode = ((AbstractDependencyGraph)this.getGraph()).getNode(receiverContainer.getId());
            if (senderNode == null) {
                senderNode = new DependencyGraphNode<ExecutionContainer>(senderContainer.getId(), senderContainer, t.getTraceInformation(), this.getOriginRetentionPolicy());
                ((AbstractDependencyGraph)this.getGraph()).addNode(senderContainer.getId(), senderNode);
            } else {
                this.handleOrigin(senderNode, t.getTraceInformation());
            }
            if (receiverNode == null) {
                receiverNode = new DependencyGraphNode<ExecutionContainer>(receiverContainer.getId(), receiverContainer, t.getTraceInformation(), this.getOriginRetentionPolicy());
                ((AbstractDependencyGraph)this.getGraph()).addNode(receiverContainer.getId(), receiverNode);
            } else {
                this.handleOrigin(receiverNode, t.getTraceInformation());
            }
            senderNode.addOutgoingDependency(receiverNode, t.getTraceInformation(), this.getOriginRetentionPolicy());
            receiverNode.addIncomingDependency(senderNode, t.getTraceInformation(), this.getOriginRetentionPolicy());
        }
        this.reportSuccess(t.getTraceId());
    }

    protected void onTerminating() {
        this.getOutputPort().send((Object)((AbstractDependencyGraph)this.getGraph()));
        super.onTerminating();
    }
}

