/*
 * Decompiled with CFR 0.152.
 */
package net.klakegg.pkix.ocsp;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

class OcspDigestOutputStream
extends OutputStream {
    private MessageDigest messageDigest;
    private ASN1ObjectIdentifier objectIdentifier;

    public OcspDigestOutputStream(String algorithm, String objectIdentifier) {
        this(algorithm, new ASN1ObjectIdentifier(objectIdentifier));
    }

    public OcspDigestOutputStream(String algorithm, ASN1ObjectIdentifier objectIdentifier) {
        try {
            this.messageDigest = MessageDigest.getInstance(algorithm);
            this.objectIdentifier = objectIdentifier;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.messageDigest.update((byte)b);
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return new AlgorithmIdentifier(this.objectIdentifier);
    }

    public byte[] getDigest() {
        return this.messageDigest.digest();
    }

    public byte[] calculate(byte[] bytes) throws IOException {
        this.write(bytes);
        return this.getDigest();
    }
}

