/*
 * Decompiled with CFR 0.152.
 */
package net.klakegg.pkix.ocsp;

import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.Collections;
import net.klakegg.pkix.ocsp.AbstractOcspClient;
import net.klakegg.pkix.ocsp.OcspException;
import net.klakegg.pkix.ocsp.OcspRequest;
import net.klakegg.pkix.ocsp.OcspResponse;
import net.klakegg.pkix.ocsp.OcspResult;
import net.klakegg.pkix.ocsp.builder.BuildHandler;
import net.klakegg.pkix.ocsp.builder.Builder;
import net.klakegg.pkix.ocsp.builder.Properties;

public class OcspMultiClient
extends AbstractOcspClient {
    public static Builder<OcspMultiClient> builder() {
        return new Builder<OcspMultiClient>(new BuildHandler<OcspMultiClient>(){

            @Override
            public OcspMultiClient build(Properties properties) {
                return new OcspMultiClient(properties);
            }
        });
    }

    private OcspMultiClient(Properties properties) {
        super(properties);
    }

    public OcspResult verify(X509Certificate ... certificates) throws OcspException {
        if (certificates.length == 0) {
            return new OcspResult(Collections.emptyMap());
        }
        X509Certificate issuer = this.findIntermediate(certificates[0]);
        URI uri = (URI)this.properties.get(OVERRIDE_URL);
        if (uri == null && (uri = this.detectOcspUri(certificates[0])) == null) {
            return OcspResult.empty();
        }
        OcspRequest request = new OcspRequest();
        request.setIssuer(issuer, (String)this.properties.get(DIGEST_ALGORITHM), (String)this.properties.get(DIGEST_OBJECT_IDENTIFIER));
        request.setCertificates(certificates);
        if (((Boolean)this.properties.get(NONCE)).booleanValue()) {
            request.addNonce();
        }
        OcspResponse response = this.fetch(request, uri);
        response.verifyResponse();
        return response.getResult();
    }
}

