/*
 * Decompiled with CFR 0.152.
 */
package net.klakegg.pkix.ocsp;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.klakegg.pkix.ocsp.BCHelper;
import net.klakegg.pkix.ocsp.OcspDigestOutputStream;
import net.klakegg.pkix.ocsp.OcspException;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.CertID;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;

class OcspRequest {
    private List<Extension> extensions = new ArrayList<Extension>();
    private X509Certificate[] certificates;
    private ASN1OctetString issuerNameHash;
    private ASN1OctetString issuerKeyHash;
    private AlgorithmIdentifier algorithmIdentifier;

    OcspRequest() {
    }

    public void setIssuer(X509Certificate certificate, String digestAlgorithm, String digestOid) throws OcspException {
        try {
            OcspDigestOutputStream digestCalculator = new OcspDigestOutputStream(digestAlgorithm, digestOid);
            this.algorithmIdentifier = digestCalculator.getAlgorithmIdentifier();
            X509CertificateHolder issuerHolder = BCHelper.convertToHolder(certificate);
            this.issuerNameHash = new DEROctetString(digestCalculator.calculate(issuerHolder.toASN1Structure().getSubject().getEncoded("DER")));
            this.issuerKeyHash = new DEROctetString(digestCalculator.calculate(issuerHolder.getSubjectPublicKeyInfo().getPublicKeyData().getBytes()));
        }
        catch (IOException | CertificateEncodingException e) {
            throw new OcspException("Exception while preparing issuer data: '%s'", (Throwable)e, e.getMessage());
        }
    }

    public void addNonce() {
        byte[] nonce = new byte[16];
        ThreadLocalRandom.current().nextBytes(nonce);
        this.addExtension(new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)new DEROctetString(nonce)));
    }

    public void addExtension(Extension extension) {
        this.extensions.add(extension);
    }

    public void setCertificates(X509Certificate ... certificates) {
        this.certificates = certificates;
    }

    protected byte[] generateRequest() throws OcspException {
        try {
            OCSPReqBuilder reqBuilder = new OCSPReqBuilder();
            for (X509Certificate certificate : this.certificates) {
                reqBuilder.addRequest(new CertificateID(new CertID(this.algorithmIdentifier, this.issuerNameHash, this.issuerKeyHash, new ASN1Integer(certificate.getSerialNumber()))));
            }
            if (this.extensions.size() > 0) {
                reqBuilder.setRequestExtensions(new Extensions(this.extensions.toArray(new Extension[this.extensions.size()])));
            }
            return reqBuilder.build().getEncoded();
        }
        catch (IOException | OCSPException e) {
            throw new OcspException("Exception while creating OCSP request: '%s'", e, e.getMessage());
        }
    }
}

