/*
 * Decompiled with CFR 0.152.
 */
package net.klakegg.pkix.ocsp;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Map;
import net.klakegg.pkix.ocsp.CertificateResult;

public class OcspResult {
    private final Map<BigInteger, CertificateResult> map;

    protected static OcspResult empty() {
        return new OcspResult(Collections.emptyMap());
    }

    protected OcspResult(Map<BigInteger, CertificateResult> map) {
        this.map = Collections.unmodifiableMap(map);
    }

    public CertificateResult get(BigInteger serialNumber) {
        return this.map.get(serialNumber);
    }

    public CertificateResult get(X509Certificate certificate) {
        return this.get(certificate.getSerialNumber());
    }
}

