/*
 * Decompiled with CFR 0.152.
 */
package net.klakegg.pkix.ocsp.fetcher;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import net.klakegg.pkix.ocsp.api.OcspFetcher;
import net.klakegg.pkix.ocsp.api.OcspFetcherResponse;
import net.klakegg.pkix.ocsp.builder.BuildHandler;
import net.klakegg.pkix.ocsp.builder.Builder;
import net.klakegg.pkix.ocsp.builder.Properties;
import net.klakegg.pkix.ocsp.fetcher.AbstractOcspFetcher;

public class UrlOcspFetcher
extends AbstractOcspFetcher {
    public static Builder<OcspFetcher> builder() {
        return new Builder<OcspFetcher>(new BuildHandler<OcspFetcher>(){

            @Override
            public OcspFetcher build(Properties properties) {
                return new UrlOcspFetcher(properties);
            }
        });
    }

    public UrlOcspFetcher(Properties properties) {
        super(properties);
    }

    @Override
    public OcspFetcherResponse fetch(URI uri, byte[] content) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
        connection.setConnectTimeout((Integer)this.properties.get(TIMEOUT_CONNECT));
        connection.setReadTimeout((Integer)this.properties.get(TIMEOUT_READ));
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/ocsp-request");
        connection.setRequestProperty("Accept", "application/ocsp-response");
        try (OutputStream os = connection.getOutputStream();){
            os.write(content);
        }
        return new UrlOcspFetcherResponse(connection);
    }

    private class UrlOcspFetcherResponse
    implements OcspFetcherResponse {
        private HttpURLConnection connection;

        public UrlOcspFetcherResponse(HttpURLConnection connection) {
            this.connection = connection;
        }

        @Override
        public int getStatus() throws IOException {
            return this.connection.getResponseCode();
        }

        @Override
        public String getContentType() {
            return this.connection.getContentType();
        }

        @Override
        public InputStream getContent() throws IOException {
            return this.connection.getInputStream();
        }

        @Override
        public void close() throws IOException {
        }
    }
}

