/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.kuujo.catalog.client.Command;
import net.kuujo.catalog.client.Operation;
import net.kuujo.catalog.client.Query;
import net.kuujo.catalog.client.session.ClientSession;
import net.kuujo.catalog.client.session.Session;
import net.kuujo.catalyst.serializer.SerializableTypeResolver;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.serializer.ServiceLoaderTypeResolver;
import net.kuujo.catalyst.transport.Address;
import net.kuujo.catalyst.transport.Transport;
import net.kuujo.catalyst.util.Assert;
import net.kuujo.catalyst.util.ConfigurationException;
import net.kuujo.catalyst.util.Managed;
import net.kuujo.catalyst.util.concurrent.Context;
import net.kuujo.catalyst.util.concurrent.Futures;

public class RaftClient
implements Managed<RaftClient> {
    private final Transport transport;
    private final Collection<Address> members;
    private final Serializer serializer;
    private ClientSession session;
    private CompletableFuture<RaftClient> openFuture;
    private CompletableFuture<Void> closeFuture;

    public static Builder builder(Address ... members) {
        return RaftClient.builder(Arrays.asList((Object[])Assert.notNull((Object)members, (String)"members")));
    }

    public static Builder builder(Collection<Address> members) {
        return new Builder(members);
    }

    protected RaftClient(Transport transport, Collection<Address> members, Serializer serializer) {
        serializer.resolve(new SerializableTypeResolver[]{new ServiceLoaderTypeResolver()});
        this.transport = (Transport)Assert.notNull((Object)transport, (String)"transport");
        this.members = (Collection)Assert.notNull(members, (String)"members");
        this.serializer = (Serializer)Assert.notNull((Object)serializer, (String)"serializer");
    }

    public Context context() {
        return this.session != null ? this.session.context() : null;
    }

    public Session session() {
        return this.session;
    }

    public <T> CompletableFuture<T> submit(Operation<T> operation) {
        Assert.notNull(operation, (String)"operation");
        if (operation instanceof Command) {
            return this.submit((Command)operation);
        }
        if (operation instanceof Query) {
            return this.submit((Query)operation);
        }
        throw new IllegalArgumentException("unknown operation type");
    }

    public <T> CompletableFuture<T> submit(Command<T> command) {
        Assert.notNull(command, (String)"command");
        if (this.session == null) {
            return Futures.exceptionalFuture((Throwable)new IllegalStateException("client not open"));
        }
        return this.session.submit(command);
    }

    public <T> CompletableFuture<T> submit(Query<T> query) {
        Assert.notNull(query, (String)"query");
        if (this.session == null) {
            return Futures.exceptionalFuture((Throwable)new IllegalStateException("client not open"));
        }
        return this.session.submit(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<RaftClient> open() {
        if (this.session != null && this.session.isOpen()) {
            return CompletableFuture.completedFuture(this);
        }
        if (this.openFuture == null) {
            RaftClient raftClient = this;
            synchronized (raftClient) {
                if (this.openFuture == null) {
                    ClientSession session = new ClientSession(this.transport, this.members, this.serializer);
                    this.openFuture = this.closeFuture == null ? session.open().thenApply(s -> {
                        RaftClient raftClient = this;
                        synchronized (raftClient) {
                            this.openFuture = null;
                            this.session = session;
                            return this;
                        }
                    }) : this.closeFuture.thenCompose(v -> session.open().thenApply(s -> {
                        RaftClient raftClient = this;
                        synchronized (raftClient) {
                            this.openFuture = null;
                            this.session = session;
                            return this;
                        }
                    }));
                }
            }
        }
        return this.openFuture;
    }

    public boolean isOpen() {
        return this.session != null && this.session.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> close() {
        if (this.session == null || !this.session.isOpen()) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.closeFuture == null) {
            RaftClient raftClient = this;
            synchronized (raftClient) {
                if (this.session == null) {
                    return CompletableFuture.completedFuture(null);
                }
                if (this.closeFuture == null) {
                    this.closeFuture = this.openFuture == null ? this.session.close().whenComplete((result, error) -> {
                        RaftClient raftClient = this;
                        synchronized (raftClient) {
                            this.session = null;
                            this.closeFuture = null;
                        }
                    }) : this.openFuture.thenCompose(v -> this.session.close().whenComplete((result, error) -> {
                        RaftClient raftClient = this;
                        synchronized (raftClient) {
                            this.session = null;
                            this.closeFuture = null;
                        }
                    }));
                }
            }
        }
        return this.closeFuture;
    }

    public boolean isClosed() {
        return this.session == null || this.session.isClosed();
    }

    public static class Builder
    extends net.kuujo.catalyst.util.Builder<RaftClient> {
        private Transport transport;
        private Serializer serializer;
        private Set<Address> members;

        private Builder(Collection<Address> members) {
            this.members = new HashSet<Address>((Collection)Assert.notNull(members, (String)"members"));
        }

        protected void reset() {
            this.transport = null;
            this.serializer = null;
            this.members = null;
        }

        public Builder withTransport(Transport transport) {
            this.transport = (Transport)Assert.notNull((Object)transport, (String)"transport");
            return this;
        }

        public Builder withSerializer(Serializer serializer) {
            this.serializer = (Serializer)Assert.notNull((Object)serializer, (String)"serializer");
            return this;
        }

        public RaftClient build() {
            if (this.transport == null) {
                try {
                    this.transport = (Transport)Class.forName("net.kuujo.catalyst.transport.NettyTransport").newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new ConfigurationException("transport not configured", new Object[0]);
                }
            }
            if (this.serializer == null) {
                this.serializer = new Serializer();
            }
            return new RaftClient(this.transport, this.members, this.serializer);
        }
    }
}

