/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.util;

public final class Assert {
    private Assert() {
    }

    public static void arg(boolean expression, String errorMessageFormat, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(errorMessageFormat, args));
        }
    }

    public static <T> T arg(T argument, boolean expression, String errorMessageFormat, Object ... args) {
        Assert.arg(expression, errorMessageFormat, args);
        return argument;
    }

    public static void argNot(boolean expression, String errorMessageFormat, Object ... args) {
        Assert.arg(!expression, errorMessageFormat, args);
    }

    public static <T> T argNot(T argument, boolean expression, String errorMessageFormat, Object ... args) {
        return Assert.arg(argument, !expression, errorMessageFormat, args);
    }

    public static void index(boolean expression, String errorMessageFormat, Object ... args) {
        if (!expression) {
            throw new IndexOutOfBoundsException(String.format(errorMessageFormat, args));
        }
    }

    public static void indexNot(boolean expression, String errorMessageFormat, Object ... args) {
        Assert.index(!expression, errorMessageFormat, args);
    }

    public static <T> T notNull(T reference, String parameterName) {
        if (reference == null) {
            throw new NullPointerException(parameterName + " cannot be null");
        }
        return reference;
    }

    public static void state(boolean expression, String errorMessageFormat, Object ... args) {
        if (!expression) {
            throw new IllegalStateException(String.format(errorMessageFormat, args));
        }
    }

    public static void stateNot(boolean expression, String errorMessageFormat, Object ... args) {
        Assert.state(!expression, errorMessageFormat, args);
    }
}

