/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.util;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import net.kuujo.catalyst.util.Assert;
import net.kuujo.catalyst.util.Builder;

public class BuilderPool<T extends Builder<U>, U> {
    private final Function<BuilderPool<T, U>, T> factory;
    private final Queue<T> pool = new ConcurrentLinkedQueue<T>();

    public BuilderPool(Function<BuilderPool<T, U>, T> factory) {
        this.factory = Assert.notNull(factory, "factory");
    }

    public T acquire() {
        Builder builder = (Builder)this.pool.poll();
        if (builder == null) {
            builder = (Builder)this.factory.apply(this);
        }
        builder.reset();
        return (T)builder;
    }

    public T acquire(U object) {
        Builder builder = (Builder)this.pool.poll();
        if (builder == null) {
            builder = (Builder)this.factory.apply(this);
        }
        builder.reset(object);
        return (T)builder;
    }

    public void release(T builder) {
        this.pool.add(builder);
    }
}

