/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.util;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.kuujo.catalyst.util.Assert;
import net.kuujo.catalyst.util.Listener;
import net.kuujo.catalyst.util.concurrent.Context;

public class Listeners<T>
implements Iterable<Listener<T>> {
    private final List<Listener<T>> listeners = new CopyOnWriteArrayList<Listener<T>>();

    public int size() {
        return this.listeners.size();
    }

    public Listener<T> add(final Consumer<T> listener) {
        Assert.notNull(listener, "listener");
        final Context context = Context.currentContext();
        Listener wrapper = new Listener<T>(){

            @Override
            public void accept(T event) {
                if (context != null) {
                    context.executor().execute(() -> listener.accept(event));
                } else {
                    listener.accept(event);
                }
            }

            @Override
            public void close() {
                Listeners.this.listeners.remove(this);
            }
        };
        this.listeners.add(wrapper);
        return wrapper;
    }

    @Override
    public Iterator<Listener<T>> iterator() {
        return this.listeners.iterator();
    }
}

