/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.util.concurrent;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class ComposableFuture<T>
extends CompletableFuture<T>
implements BiConsumer<T, Throwable> {
    @Override
    public void accept(T result, Throwable error) {
        if (error == null) {
            this.complete(result);
        } else {
            this.completeExceptionally(error);
        }
    }

    public CompletableFuture<T> except(Consumer<Throwable> consumer) {
        return this.whenComplete((T result, U error) -> {
            if (error != null) {
                consumer.accept((Throwable)error);
            }
        });
    }

    public CompletableFuture<T> exceptAsync(Consumer<Throwable> consumer) {
        return this.whenCompleteAsync((T result, U error) -> {
            if (error != null) {
                consumer.accept((Throwable)error);
            }
        });
    }

    public CompletableFuture<T> exceptAsync(Consumer<Throwable> consumer, Executor executor) {
        return this.whenCompleteAsync((T result, U error) -> {
            if (error != null) {
                consumer.accept((Throwable)error);
            }
        }, executor);
    }
}

