/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.util.concurrent;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.util.concurrent.CatalystThread;
import net.kuujo.catalyst.util.concurrent.Scheduled;
import org.slf4j.Logger;

public interface Context
extends AutoCloseable {
    public static Context currentContext() {
        Thread thread = Thread.currentThread();
        return thread instanceof CatalystThread ? ((CatalystThread)thread).getContext() : null;
    }

    default public void checkThread() {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof CatalystThread) || ((CatalystThread)thread).getContext() != this) {
            throw new IllegalStateException("not running on the correct thread");
        }
    }

    public Logger logger();

    public Serializer serializer();

    public Executor executor();

    default public CompletableFuture<Void> execute(Runnable callback) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.executor().execute(() -> {
            try {
                callback.run();
                future.complete(null);
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    default public <T> CompletableFuture<T> execute(Supplier<T> callback) {
        CompletableFuture future = new CompletableFuture();
        this.executor().execute(() -> {
            try {
                future.complete(callback.get());
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    public Scheduled schedule(Runnable var1, Duration var2);

    public Scheduled schedule(Runnable var1, Duration var2, Duration var3);

    @Override
    public void close();
}

