/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.util.concurrent;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.util.concurrent.CatalystThread;
import net.kuujo.catalyst.util.concurrent.CatalystThreadFactory;
import net.kuujo.catalyst.util.concurrent.Context;
import net.kuujo.catalyst.util.concurrent.Scheduled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleThreadContext
implements Context {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleThreadContext.class);
    private final ScheduledExecutorService executor;
    private final Serializer serializer;
    private final Executor wrappedExecutor = new Executor(){

        @Override
        public void execute(Runnable command) {
            SingleThreadContext.this.executor.execute(() -> {
                try {
                    command.run();
                }
                catch (Throwable t) {
                    LOGGER.error("An uncaught exception occurred", t);
                    t.printStackTrace();
                    throw t;
                }
            });
        }
    };

    public SingleThreadContext(String name, Serializer serializer) {
        this(Executors.newSingleThreadScheduledExecutor(new CatalystThreadFactory(name)), serializer);
    }

    public SingleThreadContext(ScheduledExecutorService executor, Serializer serializer) {
        this(SingleThreadContext.getThread(executor), executor, serializer);
    }

    public SingleThreadContext(Thread thread, ScheduledExecutorService executor, Serializer serializer) {
        this.executor = executor;
        this.serializer = serializer;
        if (!(thread instanceof CatalystThread)) {
            throw new IllegalStateException("not a Catalyst thread");
        }
        ((CatalystThread)thread).setContext(this);
    }

    protected static CatalystThread getThread(ExecutorService executor) {
        AtomicReference thread = new AtomicReference();
        try {
            executor.submit(() -> thread.set((CatalystThread)Thread.currentThread())).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("failed to initialize thread state", e);
        }
        return (CatalystThread)thread.get();
    }

    @Override
    public Logger logger() {
        return LOGGER;
    }

    @Override
    public Serializer serializer() {
        return this.serializer;
    }

    @Override
    public Executor executor() {
        return this.wrappedExecutor;
    }

    @Override
    public Scheduled schedule(Runnable runnable, Duration delay) {
        ScheduledFuture<?> future = this.executor.schedule(this.wrapRunnable(runnable), delay.toMillis(), TimeUnit.MILLISECONDS);
        return () -> future.cancel(false);
    }

    @Override
    public Scheduled schedule(Runnable runnable, Duration delay, Duration interval) {
        ScheduledFuture<?> future = this.executor.scheduleAtFixedRate(this.wrapRunnable(runnable), delay.toMillis(), interval.toMillis(), TimeUnit.MILLISECONDS);
        return () -> future.cancel(false);
    }

    private Runnable wrapRunnable(Runnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOGGER.error("An uncaught exception occurred", t);
                t.printStackTrace();
                throw t;
            }
        };
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }
}

