/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.util.concurrent;

import java.time.Duration;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.util.concurrent.CatalystThread;
import net.kuujo.catalyst.util.concurrent.Context;
import net.kuujo.catalyst.util.concurrent.Scheduled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolContext
implements Context {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadPoolContext.class);
    private final ScheduledExecutorService parent;
    private final Serializer serializer;
    private final Runnable runner;
    private final LinkedList<Runnable> tasks = new LinkedList();
    private boolean running;
    private final Executor executor = new Executor(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            LinkedList linkedList = ThreadPoolContext.this.tasks;
            synchronized (linkedList) {
                ThreadPoolContext.this.tasks.add(command);
                if (!ThreadPoolContext.this.running) {
                    ThreadPoolContext.this.running = true;
                    ThreadPoolContext.this.parent.execute(ThreadPoolContext.this.runner);
                }
            }
        }
    };

    public ThreadPoolContext(ScheduledExecutorService parent, Serializer serializer) {
        if (parent == null) {
            throw new NullPointerException("parent cannot be null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer cannot be null");
        }
        this.parent = parent;
        this.serializer = serializer;
        this.runner = () -> {
            ((CatalystThread)Thread.currentThread()).setContext(this);
            while (true) {
                Runnable task;
                LinkedList<Runnable> linkedList = this.tasks;
                synchronized (linkedList) {
                    task = this.tasks.poll();
                    if (task == null) {
                        this.running = false;
                        return;
                    }
                }
                try {
                    task.run();
                }
                catch (Throwable t) {
                    LOGGER.error("An uncaught exception occurred", t);
                    t.printStackTrace();
                    throw t;
                }
            }
        };
    }

    @Override
    public Logger logger() {
        return LOGGER;
    }

    @Override
    public Serializer serializer() {
        return this.serializer;
    }

    @Override
    public Executor executor() {
        return this.executor;
    }

    @Override
    public Scheduled schedule(Runnable runnable, Duration delay) {
        ScheduledFuture<?> future = this.parent.schedule(() -> this.executor.execute(this.wrapRunnable(runnable)), delay.toMillis(), TimeUnit.MILLISECONDS);
        return () -> future.cancel(false);
    }

    @Override
    public Scheduled schedule(Runnable runnable, Duration delay, Duration interval) {
        ScheduledFuture<?> future = this.parent.scheduleAtFixedRate(() -> this.executor.execute(this.wrapRunnable(runnable)), delay.toMillis(), interval.toMillis(), TimeUnit.MILLISECONDS);
        return () -> future.cancel(false);
    }

    private Runnable wrapRunnable(Runnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOGGER.error("An uncaught exception occurred", t);
                t.printStackTrace();
                throw t;
            }
        };
    }

    @Override
    public void close() {
    }
}

