/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.serializer;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.kuujo.catalyst.buffer.BufferInput;
import net.kuujo.catalyst.buffer.BufferOutput;
import net.kuujo.catalyst.serializer.CatalystSerializable;
import net.kuujo.catalyst.serializer.SerializationException;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.serializer.TypeSerializer;
import net.kuujo.catalyst.util.ReferenceCounted;
import net.kuujo.catalyst.util.ReferenceFactory;
import net.kuujo.catalyst.util.ReferenceManager;
import net.kuujo.catalyst.util.ReferencePool;

public class CatalystSerializableSerializer<T extends CatalystSerializable>
implements TypeSerializer<T> {
    private final Map<Class, ReferencePool> pools = new HashMap<Class, ReferencePool>();
    private final Map<Class, Constructor> constructorMap = new HashMap<Class, Constructor>();

    @Override
    public void write(T object, BufferOutput buffer, Serializer serializer) {
        object.writeObject(buffer, serializer);
    }

    @Override
    public T read(Class<T> type, BufferInput buffer, Serializer serializer) {
        if (ReferenceCounted.class.isAssignableFrom(type)) {
            return this.readReference(type, buffer, serializer);
        }
        return this.readObject(type, buffer, serializer);
    }

    private T readReference(Class<T> type, BufferInput buffer, Serializer serializer) {
        ReferencePool pool = this.pools.get(type);
        if (pool == null) {
            Constructor<T> constructor = this.constructorMap.get(type);
            if (constructor == null) {
                try {
                    constructor = type.getDeclaredConstructor(ReferenceManager.class);
                    constructor.setAccessible(true);
                    this.constructorMap.put(type, constructor);
                }
                catch (NoSuchMethodException e) {
                    throw new SerializationException("failed to instantiate reference: must provide a single argument constructor", e);
                }
            }
            pool = new ReferencePool(this.createFactory(constructor));
            this.pools.put(type, pool);
        }
        CatalystSerializable object = (CatalystSerializable)pool.acquire();
        object.readObject(buffer, serializer);
        return (T)object;
    }

    private ReferenceFactory createFactory(Constructor constructor) {
        return manager -> {
            try {
                return (ReferenceCounted)constructor.newInstance(manager);
            }
            catch (ReflectiveOperationException e) {
                throw new SerializationException("failed to instantiate reference", e);
            }
        };
    }

    private T readObject(Class<T> type, BufferInput buffer, Serializer serializer) {
        try {
            Constructor<T> constructor = this.constructorMap.get(type);
            if (constructor == null) {
                try {
                    constructor = type.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    this.constructorMap.put(type, constructor);
                }
                catch (NoSuchMethodException e) {
                    throw new SerializationException("failed to instantiate reference: must provide a single argument constructor", e);
                }
            }
            CatalystSerializable object = (CatalystSerializable)constructor.newInstance(new Object[0]);
            object.readObject(buffer, serializer);
            return (T)object;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new SerializationException("failed to instantiate object: must provide a no argument constructor", e);
        }
    }
}

