/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.serializer;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.kuujo.catalyst.serializer.SerializableTypeResolver;
import net.kuujo.catalyst.serializer.SerializerRegistry;
import net.kuujo.catalyst.serializer.TypeSerializer;
import net.kuujo.catalyst.serializer.lang.BooleanArraySerializer;
import net.kuujo.catalyst.serializer.lang.BooleanSerializer;
import net.kuujo.catalyst.serializer.lang.ByteArraySerializer;
import net.kuujo.catalyst.serializer.lang.ByteSerializer;
import net.kuujo.catalyst.serializer.lang.CharacterArraySerializer;
import net.kuujo.catalyst.serializer.lang.CharacterSerializer;
import net.kuujo.catalyst.serializer.lang.ClassSerializer;
import net.kuujo.catalyst.serializer.lang.DoubleArraySerializer;
import net.kuujo.catalyst.serializer.lang.DoubleSerializer;
import net.kuujo.catalyst.serializer.lang.EnumSerializer;
import net.kuujo.catalyst.serializer.lang.FloatArraySerializer;
import net.kuujo.catalyst.serializer.lang.FloatSerializer;
import net.kuujo.catalyst.serializer.lang.IntegerArraySerializer;
import net.kuujo.catalyst.serializer.lang.IntegerSerializer;
import net.kuujo.catalyst.serializer.lang.LongArraySerializer;
import net.kuujo.catalyst.serializer.lang.LongSerializer;
import net.kuujo.catalyst.serializer.lang.ShortArraySerializer;
import net.kuujo.catalyst.serializer.lang.ShortSerializer;
import net.kuujo.catalyst.serializer.lang.StringSerializer;

public class PrimitiveTypeResolver
implements SerializableTypeResolver {
    private static final HashMap<Class<?>, Class<? extends TypeSerializer<?>>> SERIALIZERS = new LinkedHashMap(){
        {
            this.put(Byte.TYPE, ByteSerializer.class);
            this.put(Byte.class, ByteSerializer.class);
            this.put(byte[].class, ByteArraySerializer.class);
            this.put(Byte[].class, ByteArraySerializer.class);
            this.put(Boolean.TYPE, BooleanSerializer.class);
            this.put(Boolean.class, BooleanSerializer.class);
            this.put(boolean[].class, BooleanArraySerializer.class);
            this.put(Boolean[].class, BooleanArraySerializer.class);
            this.put(Character.TYPE, CharacterSerializer.class);
            this.put(Character.class, CharacterSerializer.class);
            this.put(char[].class, CharacterArraySerializer.class);
            this.put(Character[].class, CharacterArraySerializer.class);
            this.put(Short.TYPE, ShortSerializer.class);
            this.put(Short.class, ShortSerializer.class);
            this.put(short[].class, ShortArraySerializer.class);
            this.put(Short[].class, ShortArraySerializer.class);
            this.put(Integer.TYPE, IntegerSerializer.class);
            this.put(Integer.class, IntegerSerializer.class);
            this.put(int[].class, IntegerArraySerializer.class);
            this.put(Integer[].class, IntegerArraySerializer.class);
            this.put(Long.TYPE, LongSerializer.class);
            this.put(Long.class, LongSerializer.class);
            this.put(long[].class, LongArraySerializer.class);
            this.put(Long[].class, LongArraySerializer.class);
            this.put(Float.TYPE, FloatSerializer.class);
            this.put(Float.class, FloatSerializer.class);
            this.put(float[].class, FloatArraySerializer.class);
            this.put(Float[].class, FloatArraySerializer.class);
            this.put(Double.TYPE, DoubleSerializer.class);
            this.put(Double.class, DoubleSerializer.class);
            this.put(double[].class, DoubleArraySerializer.class);
            this.put(Double[].class, DoubleArraySerializer.class);
            this.put(String.class, StringSerializer.class);
            this.put(Class.class, ClassSerializer.class);
            this.put(Enum.class, EnumSerializer.class);
        }
    };

    @Override
    public void resolve(SerializerRegistry registry) {
        int i = 128;
        for (Map.Entry<Class<?>, Class<TypeSerializer<?>>> entry : SERIALIZERS.entrySet()) {
            registry.register(entry.getKey(), entry.getValue(), i++);
        }
    }
}

