/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.serializer.collection;

import java.util.HashMap;
import java.util.Map;
import net.kuujo.catalyst.buffer.BufferInput;
import net.kuujo.catalyst.buffer.BufferOutput;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.serializer.TypeSerializer;

public class MapSerializer
implements TypeSerializer<Map> {
    @Override
    public void write(Map object, BufferOutput buffer, Serializer serializer) {
        buffer.writeUnsignedShort(object.size());
        for (Map.Entry entry : object.entrySet()) {
            serializer.writeObject(entry.getKey(), buffer);
            serializer.writeObject(entry.getValue(), buffer);
        }
    }

    @Override
    public Map read(Class<Map> type, BufferInput buffer, Serializer serializer) {
        int size = buffer.readUnsignedShort();
        HashMap object = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            Object key = serializer.readObject(buffer);
            Object value = serializer.readObject(buffer);
            object.put(key, value);
        }
        return object;
    }
}

