/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.serializer.lang;

import net.kuujo.catalyst.buffer.BufferInput;
import net.kuujo.catalyst.buffer.BufferOutput;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.serializer.TypeSerializer;

public class CharacterArraySerializer
implements TypeSerializer<char[]> {
    @Override
    public void write(char[] chars, BufferOutput buffer, Serializer serializer) {
        buffer.writeUnsignedShort(chars.length);
        for (char c : chars) {
            buffer.writeChar(c);
        }
    }

    @Override
    public char[] read(Class<char[]> type, BufferInput buffer, Serializer serializer) {
        char[] chars = new char[buffer.readUnsignedShort()];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = buffer.readChar();
        }
        return chars;
    }
}

