/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.serializer.lang;

import net.kuujo.catalyst.buffer.BufferInput;
import net.kuujo.catalyst.buffer.BufferOutput;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.serializer.TypeSerializer;

public class DoubleArraySerializer
implements TypeSerializer<double[]> {
    @Override
    public void write(double[] doubles, BufferOutput buffer, Serializer serializer) {
        buffer.writeUnsignedShort(doubles.length);
        for (double d : doubles) {
            buffer.writeDouble(d);
        }
    }

    @Override
    public double[] read(Class<double[]> type, BufferInput buffer, Serializer serializer) {
        double[] doubles = new double[buffer.readUnsignedShort()];
        for (int i = 0; i < doubles.length; ++i) {
            doubles[i] = buffer.readDouble();
        }
        return doubles;
    }
}

