/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.serializer.lang;

import net.kuujo.catalyst.buffer.BufferInput;
import net.kuujo.catalyst.buffer.BufferOutput;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.serializer.TypeSerializer;

public class IntegerArraySerializer
implements TypeSerializer<int[]> {
    @Override
    public void write(int[] ints, BufferOutput buffer, Serializer serializer) {
        buffer.writeUnsignedShort(ints.length);
        for (int i : ints) {
            buffer.writeInt(i);
        }
    }

    @Override
    public int[] read(Class<int[]> type, BufferInput buffer, Serializer serializer) {
        int[] ints = new int[buffer.readUnsignedShort()];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = buffer.readInt();
        }
        return ints;
    }
}

