/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.serializer.lang;

import net.kuujo.catalyst.buffer.BufferInput;
import net.kuujo.catalyst.buffer.BufferOutput;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.serializer.TypeSerializer;

public class LongArraySerializer
implements TypeSerializer<long[]> {
    @Override
    public void write(long[] longs, BufferOutput buffer, Serializer serializer) {
        buffer.writeUnsignedShort(longs.length);
        for (long l : longs) {
            buffer.writeLong(l);
        }
    }

    @Override
    public long[] read(Class<long[]> type, BufferInput buffer, Serializer serializer) {
        long[] longs = new long[buffer.readUnsignedShort()];
        for (int i = 0; i < longs.length; ++i) {
            longs[i] = buffer.readLong();
        }
        return longs;
    }
}

