/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.serializer.util;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import net.kuujo.catalyst.buffer.BufferInput;
import net.kuujo.catalyst.buffer.BufferOutput;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.serializer.TypeSerializer;

public class BigIntegerSerializer
implements TypeSerializer<BigInteger> {
    @Override
    public void write(BigInteger object, BufferOutput buffer, Serializer serializer) {
        byte[] bytes = object.toString().getBytes(StandardCharsets.UTF_8);
        buffer.writeInt(bytes.length).write(bytes);
    }

    @Override
    public BigInteger read(Class<BigInteger> type, BufferInput buffer, Serializer serializer) {
        byte[] bytes = new byte[buffer.readInt()];
        buffer.read(bytes);
        return new BigInteger(new String(bytes, StandardCharsets.UTF_8));
    }
}

