/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric;

import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.platform.fabric.impl.ControlledAudience;
import net.kyori.adventure.platform.fabric.impl.FabricAudiencesInternal;
import net.kyori.adventure.platform.fabric.impl.server.FabricServerAudiencesImpl;
import net.kyori.adventure.resource.ResourcePackCallback;
import net.kyori.adventure.resource.ResourcePackStatus;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FabricResourcePackCallback {
    private static final ComponentLogger LOGGER = ComponentLogger.logger();
    private static final Component DEFAULT_KICK_MESSAGE = Component.translatable((String)"multiplayer.requiredTexturePrompt.disconnect");

    private FabricResourcePackCallback() {
    }

    @NotNull
    public static ResourcePackCallback kickIfNotApplied() {
        return FabricResourcePackCallback.kickIfNotApplied(DEFAULT_KICK_MESSAGE);
    }

    @NotNull
    public static ResourcePackCallback kickIfNotApplied(@NotNull Component kickMessage) {
        Objects.requireNonNull(kickMessage, "kickMessage");
        return (uuid, status, audience) -> {
            if (!status.intermediate() && status != ResourcePackStatus.SUCCESSFULLY_LOADED) {
                class_3244 kicker;
                if (!(audience instanceof ControlledAudience)) {
                    LOGGER.debug("Audience {} was not a ControlledAudience, we cannot kick them", (Object)audience);
                    return;
                }
                ControlledAudience controlled = (ControlledAudience)audience;
                if (audience instanceof class_3222) {
                    class_3222 player = (class_3222)audience;
                    kicker = player.field_13987;
                } else {
                    @Nullable UUID id = audience.get(Identity.UUID).orElse(null);
                    if (id == null) {
                        return;
                    }
                    FabricAudiencesInternal patt3881$temp = controlled.controller();
                    if (!(patt3881$temp instanceof FabricServerAudiencesImpl)) {
                        return;
                    }
                    FabricServerAudiencesImpl server = (FabricServerAudiencesImpl)patt3881$temp;
                    class_3222 ply = server.server().method_3760().method_14602(id);
                    if (ply == null) {
                        return;
                    }
                    kicker = ply.field_13987;
                }
                LOGGER.debug("Audience {} did not successfully apply a resource pack with ID {}, kicking with message: {}", new Object[]{kicker.method_52404(), uuid, kickMessage});
                kicker.method_52396(controlled.controller().toNative(kickMessage));
            }
        };
    }
}

