/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.platform.fabric.CollectPointersCallback;
import net.kyori.adventure.platform.fabric.ComponentArgumentType;
import net.kyori.adventure.platform.fabric.FabricAudiences;
import net.kyori.adventure.platform.fabric.KeyArgumentType;
import net.kyori.adventure.platform.fabric.PlayerLocales;
import net.kyori.adventure.platform.fabric.impl.ClickCallbackRegistry;
import net.kyori.adventure.platform.fabric.impl.ComponentArgumentTypeSerializer;
import net.kyori.adventure.platform.fabric.impl.FabricAudiencesInternal;
import net.kyori.adventure.platform.fabric.impl.LocaleHolderBridge;
import net.kyori.adventure.platform.fabric.impl.ServerArgumentType;
import net.kyori.adventure.platform.fabric.impl.ServerArgumentTypes;
import net.kyori.adventure.platform.fabric.impl.ServerboundRegisteredArgumentTypesPacket;
import net.kyori.adventure.platform.fabric.impl.SidedProxy;
import net.kyori.adventure.platform.fabric.impl.server.FabricServerAudiencesImpl;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.TranslationRegistry;
import net.kyori.adventure.translation.Translator;
import net.minecraft.class_2168;
import net.minecraft.class_2178;
import net.minecraft.class_2232;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2477;
import net.minecraft.class_2556;
import net.minecraft.class_2960;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class AdventureCommon
implements ModInitializer {
    private static final Logger LOGGER;
    public static final ScheduledExecutorService SCHEDULER;
    public static final SidedProxy SIDE_PROXY;
    public static final ComponentFlattener FLATTENER;
    private static final Pattern LOCALIZATION_PATTERN;
    public static final String MOD_FAPI_NETWORKING = "fabric-networking-api-v1";

    private static SidedProxy chooseSidedProxy() {
        EnvType environment = FabricLoader.getInstance().getEnvironmentType();
        List sidedProxyContainers = FabricLoader.getInstance().getEntrypointContainers("adventure-internal:sidedproxy/" + environment.name().toLowerCase(Locale.ROOT), SidedProxy.class);
        return switch (sidedProxyContainers.size()) {
            case 0 -> throw new IllegalStateException("No sided proxies were available for adventure-platform-fabric in environment " + environment);
            case 1 -> {
                EntrypointContainer proxy = (EntrypointContainer)sidedProxyContainers.get(0);
                LOGGER.debug("Selected sided proxy {} from {}", proxy.getEntrypoint(), (Object)proxy.getProvider().getMetadata().getId());
                yield (SidedProxy)proxy.getEntrypoint();
            }
            default -> {
                EntrypointContainer proxy = (EntrypointContainer)sidedProxyContainers.get(0);
                LOGGER.warn("Multiple applicable proxies were applicable, choosing first available: {} from {}", proxy.getEntrypoint(), (Object)proxy.getProvider().getMetadata().getId());
                yield (SidedProxy)proxy.getEntrypoint();
            }
        };
    }

    private static ComponentFlattener createFlattener(SidedProxy proxy) {
        ComponentFlattener.Builder flattenerBuilder = (ComponentFlattener.Builder)ComponentFlattener.basic().toBuilder();
        proxy.contributeFlattenerElements(flattenerBuilder);
        flattenerBuilder.complexMapper(TranslatableComponent.class, (translatable, consumer) -> {
            String key = translatable.key();
            for (Translator registry : GlobalTranslator.translator().sources()) {
                TranslationRegistry tr;
                if (!(registry instanceof TranslationRegistry) || !(tr = (TranslationRegistry)registry).contains(key)) continue;
                consumer.accept(GlobalTranslator.render((Component)translatable, (Locale)Locale.getDefault()));
                return;
            }
            @Nullable String translated = Objects.requireNonNullElse(class_2477.method_10517().method_4679(key, translatable.fallback()), key);
            Matcher matcher = LOCALIZATION_PATTERN.matcher(translated);
            List args = translatable.arguments();
            int argPosition = 0;
            int lastIdx = 0;
            while (matcher.find()) {
                int idx;
                if (lastIdx < matcher.start()) {
                    consumer.accept(Component.text((String)translated.substring(lastIdx, matcher.start())));
                }
                lastIdx = matcher.end();
                @Nullable String argIdx = matcher.group(1);
                if (argIdx != null) {
                    try {
                        idx = Integer.parseInt(argIdx) - 1;
                        if (idx >= args.size()) continue;
                        consumer.accept(((TranslationArgument)args.get(idx)).asComponent());
                    }
                    catch (NumberFormatException idx2) {}
                    continue;
                }
                if ((idx = argPosition++) >= args.size()) continue;
                consumer.accept(((TranslationArgument)args.get(idx)).asComponent());
            }
            if (lastIdx < translated.length()) {
                consumer.accept(Component.text((String)translated.substring(lastIdx)));
            }
        });
        return (ComponentFlattener)flattenerBuilder.build();
    }

    static class_2960 res(@NotNull String value) {
        return new class_2960("adventure", value);
    }

    public void onInitialize() {
        this.setupCustomArgumentTypes();
        PlayerLocales.CHANGED_EVENT.register((player, locale) -> FabricServerAudiencesImpl.forEachInstance(instance -> instance.bossBars().refreshTitles(player)));
        CollectPointersCallback.EVENT.register((pointered, builder) -> {
            if (pointered instanceof LocaleHolderBridge) {
                LocaleHolderBridge holder = (LocaleHolderBridge)pointered;
                builder.withDynamic(Identity.LOCALE, holder::adventure$locale);
            }
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registries, env) -> ClickCallbackRegistry.INSTANCE.registerToDispatcher((CommandDispatcher<class_2168>)dispatcher));
        SCHEDULER.scheduleWithFixedDelay(ClickCallbackRegistry.INSTANCE::cleanUp, 30L, 30L, TimeUnit.SECONDS);
        if (Boolean.getBoolean("adventure.testMode") && FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            ServerLifecycleEvents.SERVER_STARTED.register(server -> {
                MixinEnvironment.getCurrentEnvironment().audit();
                server.execute(() -> {
                    try {
                        Files.writeString(Path.of("adventure-test-success.out", new String[0]), (CharSequence)"true", new OpenOption[0]);
                    }
                    catch (IOException ex) {
                        System.exit(1);
                    }
                    server.method_3747(false);
                });
            });
        }
    }

    private void setupCustomArgumentTypes() {
        if (FabricLoader.getInstance().isModLoaded(MOD_FAPI_NETWORKING)) {
            ServerboundRegisteredArgumentTypesPacket.register();
        }
        ServerArgumentTypes.register(new ServerArgumentType<ComponentArgumentType>(AdventureCommon.res("component"), ComponentArgumentType.class, ComponentArgumentTypeSerializer.INSTANCE, arg -> switch (arg.format()) {
            default -> throw new IncompatibleClassChangeError();
            case ComponentArgumentType.Format.JSON -> class_2178.method_9281();
            case ComponentArgumentType.Format.MINIMESSAGE -> StringArgumentType.greedyString();
        }, null));
        ServerArgumentTypes.register(new ServerArgumentType<KeyArgumentType>(AdventureCommon.res("key"), KeyArgumentType.class, (class_2314<KeyArgumentType, class_2314.class_7217<KeyArgumentType>>)class_2319.method_41999(KeyArgumentType::key), (Function<KeyArgumentType, ArgumentType<?>>)((Function<KeyArgumentType, ArgumentType>)arg -> class_2232.method_9441()), null));
    }

    public static Function<Pointered, Locale> localePartition() {
        return ptr -> (Locale)ptr.getOrDefault(Identity.LOCALE, (Object)Locale.US);
    }

    public static Pointered pointered(FPointered pointers) {
        return pointers;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2556.class_7602 chatTypeToNative(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ChatType.Bound bound, FabricAudiencesInternal audiences) {
        class_2556 type = (class_2556)audiences.registryAccess().method_30530(class_7924.field_41237).method_10223(FabricAudiences.toNative(bound.type().key()));
        if (type == null) {
            throw new IllegalArgumentException("Could not resolve chat type for key " + bound.type().key());
        }
        class_2556.class_7602 ret = type.method_44835(audiences.toNative(bound.name()));
        return bound.target() == null ? ret : ret.method_44839(audiences.toNative(bound.target()));
    }

    static {
        SidedProxy sidedProxy;
        LOGGER = LogUtils.getLogger();
        LOCALIZATION_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?s");
        SCHEDULER = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("adventure-platform-fabric-scheduler-%d").setDaemon(true).setUncaughtExceptionHandler((thread, ex) -> LOGGER.error("An uncaught exception occurred in scheduler thread '{}':", (Object)thread.getName(), (Object)ex)).build());
        SIDE_PROXY = sidedProxy = AdventureCommon.chooseSidedProxy();
        FLATTENER = AdventureCommon.createFlattener(sidedProxy);
    }

    @FunctionalInterface
    static interface FPointered
    extends Pointered {
        @NotNull
        public Pointers pointers();
    }
}

