/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric.impl;

import com.mojang.brigadier.arguments.ArgumentType;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.kyori.adventure.platform.fabric.impl.ClientboundArgumentTypeMappingsPacket;
import net.kyori.adventure.platform.fabric.impl.ServerArgumentType;
import net.kyori.adventure.platform.fabric.impl.server.ServerPlayerBridge;
import net.minecraft.class_2314;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public final class ServerArgumentTypes {
    private static final Map<Class<?>, ServerArgumentType<?>> BY_TYPE = new HashMap();
    private static final Map<class_2960, ServerArgumentType<?>> BY_LOCATION = new ConcurrentHashMap();
    private static final Map<class_2314<?, ?>, ServerArgumentType<?>> BY_INFO = new HashMap();
    private static final Int2ObjectMap<ServerArgumentType<?>> BY_ID = new Int2ObjectArrayMap();
    private static final Reference2IntMap<class_2314<?, ?>> IDS_BY_TYPE_INFO = new Reference2IntOpenHashMap();
    private static final AtomicInteger ID_COUNTER = new AtomicInteger(100000);
    @Nullable
    private static Int2ObjectMap<ServerArgumentType<?>> BY_ID_ACTIVE_SERVER = null;

    public static <T extends ArgumentType<?>> ServerArgumentType<T> byClass(Class<T> clazz) {
        return BY_TYPE.get(Objects.requireNonNull(clazz, "clazz"));
    }

    private ServerArgumentTypes() {
    }

    public static void register(ServerArgumentType<?> type) {
        int id = ID_COUNTER.getAndIncrement();
        BY_ID.put(id, type);
        IDS_BY_TYPE_INFO.put(type.argumentTypeInfo(), id);
        BY_INFO.put(type.argumentTypeInfo(), type);
        BY_TYPE.put(type.type(), type);
        BY_LOCATION.put(type.id(), type);
    }

    public static Set<class_2960> ids() {
        return Collections.unmodifiableSet(BY_LOCATION.keySet());
    }

    public static boolean isServerType(class_2314<?, ?> argumentTypeInfo) {
        return IDS_BY_TYPE_INFO.containsKey(argumentTypeInfo);
    }

    public static boolean hasId(int id) {
        return BY_ID.containsKey(id);
    }

    public static ServerArgumentType<?> byId(int id) {
        return (ServerArgumentType)Objects.requireNonNullElse(BY_ID_ACTIVE_SERVER, BY_ID).get(id);
    }

    public static ServerArgumentType<?> serverType(class_2314<?, ?> argumentTypeInfo) {
        return BY_INFO.get(argumentTypeInfo);
    }

    public static int id(class_2314<?, ?> argumentTypeInfo) {
        return IDS_BY_TYPE_INFO.getInt(argumentTypeInfo);
    }

    public static void knownArgumentTypes(class_3222 player, Set<class_2960> ids, PacketSender responder) {
        ((ServerPlayerBridge)player).bridge$knownArguments(ids);
        ServerArgumentTypes.sendMappings(player, responder);
        if (!ids.isEmpty()) {
            player.field_13995.method_3734().method_9241(player);
        }
    }

    public static Set<class_2960> knownArgumentTypes(class_3222 player) {
        return ((ServerPlayerBridge)player).bridge$knownArguments();
    }

    private static void sendMappings(class_3222 player, PacketSender responder) {
        Set<class_2960> known = ServerArgumentTypes.knownArgumentTypes(player);
        Int2ObjectArrayMap map = new Int2ObjectArrayMap();
        for (class_2960 resourceLocation : known) {
            ServerArgumentType<?> type = BY_LOCATION.get(resourceLocation);
            if (type == null) continue;
            map.put(ServerArgumentTypes.id(type.argumentTypeInfo()), (Object)type.id());
        }
        new ClientboundArgumentTypeMappingsPacket((Int2ObjectMap<class_2960>)map).sendTo(responder);
    }

    public static void receiveMappings(ClientboundArgumentTypeMappingsPacket packet) {
        Int2ObjectArrayMap map = new Int2ObjectArrayMap();
        for (Int2ObjectMap.Entry entry : packet.mappings().int2ObjectEntrySet()) {
            map.put(entry.getIntKey(), BY_LOCATION.get(entry.getValue()));
        }
        BY_ID_ACTIVE_SERVER = map;
    }

    static {
        IDS_BY_TYPE_INFO.defaultReturnValue(-1);
    }
}

