/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric.impl.mixin.minecraft.commands;

import java.util.Objects;
import java.util.function.Supplier;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.platform.fabric.AdventureCommandSourceStack;
import net.kyori.adventure.platform.fabric.FabricServerAudiences;
import net.kyori.adventure.platform.fabric.impl.AdventureCommandSourceStackInternal;
import net.kyori.adventure.platform.fabric.impl.server.FabricServerAudiencesImpl;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={class_2168.class})
public abstract class CommandSourceStackMixin
implements AdventureCommandSourceStackInternal {
    @Shadow
    @Final
    private class_2165 field_9819;
    @Shadow
    @Final
    private boolean field_9823;
    @Shadow
    @Final
    private MinecraftServer field_9818;
    private boolean adventure$assigned = false;
    private Audience adventure$out;
    private FabricServerAudiences adventure$controller;

    @Shadow
    protected abstract void shadow$method_9212(class_2561 var1);

    @Shadow
    public abstract void shadow$method_9226(Supplier<class_2561> var1, boolean var2);

    @Override
    public void sendSuccess(@NotNull Component text, boolean sendToOps) {
        this.shadow$method_9226(() -> this.adventure$controller.toNative(text), sendToOps);
    }

    @Override
    public void sendLazySuccess(@NotNull Supplier<Component> text, boolean sendToOps) {
        Objects.requireNonNull(text, "text");
        this.shadow$method_9226(() -> this.adventure$controller.toNative((Component)text.get()), sendToOps);
    }

    @Override
    public void sendFailure(@NotNull Component text) {
        if (this.field_9819.method_9202() && !this.field_9823) {
            this.sendMessage(text.color((TextColor)NamedTextColor.RED));
        }
    }

    @Override
    @NotNull
    public Audience audience() {
        if (this.adventure$out == null) {
            if (this.field_9818 == null) {
                throw new IllegalStateException("Cannot use adventure operations without an available server!");
            }
            this.adventure$controller = FabricServerAudiences.of(this.field_9818);
            this.adventure$out = this.adventure$controller.audience(this.field_9819);
        }
        return this.adventure$out;
    }

    @Override
    @NotNull
    public Identity identity() {
        if (this.field_9819 instanceof Identified) {
            return ((Identified)this.field_9819).identity();
        }
        return Identity.nil();
    }

    @Override
    public AdventureCommandSourceStack adventure$audience(Audience wrapped, FabricServerAudiencesImpl controller) {
        if (this.adventure$assigned && !Objects.equals(controller, this.adventure$controller)) {
            throw new IllegalStateException("This command source has been attached to a specific renderer already!");
        }
        this.adventure$assigned = true;
        this.adventure$out = wrapped;
        this.adventure$controller = controller;
        return this;
    }

    @Override
    public class_2165 adventure$source() {
        return this.field_9819;
    }
}

