/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric.impl.mixin.minecraft.network.chat;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.kyori.adventure.platform.fabric.impl.WrappedComponent;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.class_2561;
import net.minecraft.class_8824;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_8824.class})
public class ComponentSerializationMixin {
    @Inject(method={"createCodec"}, at={@At(value="RETURN")}, cancellable=true)
    private static void adventure$wrapCodec(Codec<class_2561> recursive, CallbackInfoReturnable<Codec<class_2561>> cir) {
        final Codec original = (Codec)cir.getReturnValue();
        Codec<class_2561> wrappingCodec = new Codec<class_2561>(){

            public <T> DataResult<T> encode(class_2561 input, DynamicOps<T> ops, T prefix) {
                if (input instanceof WrappedComponent) {
                    WrappedComponent w = (WrappedComponent)input;
                    if (w.deepConvertedIfPresent() != null) {
                        return original.encode((Object)w.deepConvertedIfPresent(), ops, prefix);
                    }
                    JsonElement json = GsonComponentSerializer.gson().serializeToTree(w.wrapped());
                    if (ops instanceof JsonOps) {
                        return DataResult.success((Object)json);
                    }
                    return DataResult.success((Object)JsonOps.INSTANCE.convertTo(ops, json));
                }
                return original.encode((Object)input, ops, prefix);
            }

            public <T> DataResult<Pair<class_2561, T>> decode(DynamicOps<T> ops, T input) {
                return original.decode(ops, input);
            }
        };
        cir.setReturnValue((Object)wrappingCodec);
    }
}

