/*
 * This file is part of adventure-platform-fabric, licensed under the MIT License.
 *
 * Copyright (c) 2022 KyoriPowered
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package net.kyori.adventure.platform.fabric.impl;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.kyori.adventure.Adventure;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public record ClientboundArgumentTypeMappingsPacket(Int2ObjectMap<class_2960> mappings) {
  public static final class_2960 ID = new class_2960(Adventure.NAMESPACE, "registered_arg_mappings");

  public static ClientboundArgumentTypeMappingsPacket from(final class_2540 buffer) {
    final Int2ObjectMap<class_2960> map = buffer.method_34069(
      Int2ObjectArrayMap::new,
      class_2540::method_10816,
      class_2540::method_10810
    );
    return new ClientboundArgumentTypeMappingsPacket(map);
  }

  private class_2540 serialize() {
    final class_2540 buf = new class_2540(Unpooled.buffer());
    buf.method_34063(
      this.mappings,
      class_2540::method_10804,
      class_2540::method_10812
    );
    return buf;
  }

  public void sendTo(final PacketSender responder) {
    responder.sendPacket(ID, this.serialize());
  }
}
