/*
 * This file is part of adventure-platform-fabric, licensed under the MIT License.
 *
 * Copyright (c) 2020-2022 KyoriPowered
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package net.kyori.adventure.platform.fabric.impl.client;

import java.util.function.Function;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.fabric.FabricClientAudiences;
import net.kyori.adventure.platform.fabric.impl.AdventureCommon;
import net.kyori.adventure.platform.fabric.impl.FabricAudiencesInternal;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.renderer.ComponentRenderer;
import net.kyori.adventure.translation.GlobalTranslator;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_7659;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import static java.util.Objects.requireNonNull;

public class FabricClientAudiencesImpl implements FabricClientAudiences, FabricAudiencesInternal {
  public static final FabricClientAudiences INSTANCE = new net.kyori.adventure.platform.fabric.impl.client.FabricClientAudiencesImpl.Builder().build();
  private final Function<Pointered, ?> partition;
  private final ComponentRenderer<Pointered> renderer;
  private final ClientAudience audience;

  public FabricClientAudiencesImpl(final Function<Pointered, ?> partition, final ComponentRenderer<Pointered> renderer) {
    this.partition = partition;
    this.renderer = renderer;
    this.audience = new ClientAudience(class_310.method_1551(), this);
  }

  @Override
  public @NotNull Audience audience() {
    return this.audience;
  }

  @Override
  public @NotNull ComponentFlattener flattener() {
    return AdventureCommon.FLATTENER;
  }

  @Override
  public @NotNull ComponentRenderer<Pointered> renderer() {
    return this.renderer;
  }

  @Override
  public @NotNull class_2561 toNative(final net.kyori.adventure.text.@NotNull Component adventure) {
    return new ClientWrappedComponent(requireNonNull(adventure, "adventure"), this.partition, this.renderer);
  }

  public Function<Pointered, ?> partition() {
    return this.partition;
  }

  @Override
  public @NotNull class_5455 registryAccess() {
    final @Nullable class_638 level = class_310.method_1551().field_1687;
    return level == null ? class_7659.method_45139().method_45926() : level.method_30349();
  }

  public static final class Builder implements FabricClientAudiences.Builder {
    private Function<Pointered, ?> partition;
    private ComponentRenderer<Pointered> renderer;

    public Builder() {
      this.componentRenderer(AdventureCommon.localePartition(), GlobalTranslator.renderer());
    }

    @Override
    public FabricClientAudiences.@NotNull Builder componentRenderer(final @NotNull ComponentRenderer<Pointered> componentRenderer) {
      this.renderer = requireNonNull(componentRenderer, "componentRenderer");
      return this;
    }

    @Override
    public FabricClientAudiences.@NotNull Builder partition(final @NotNull Function<Pointered, ?> partitionFunction) {
      this.partition = requireNonNull(partitionFunction, "partitionFunction");
      return this;
    }

    @Override
    public @NotNull FabricClientAudiences build() {
      return new FabricClientAudiencesImpl(this.partition, this.renderer);
    }
  }
}
