/*
 * This file is part of adventure-platform-fabric, licensed under the MIT License.
 *
 * Copyright (c) 2023 KyoriPowered
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package net.kyori.adventure.platform.fabric.impl.client;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.resource.ResourcePackCallback;
import net.kyori.adventure.resource.ResourcePackStatus;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.minecraft.class_9039;
import org.jetbrains.annotations.NotNull;

public final class ListeningPackFeedbackWrapper implements class_9039 {
  private static final ComponentLogger LOGGER = ComponentLogger.logger();
  private static final Map<UUID, PackCallback> CALLBACKS = new ConcurrentHashMap<>();

  private final class_9039 delegate;

  record PackCallback(@NotNull ResourcePackCallback cb, @NotNull ClientAudience listener) {}

  public static void registerCallback(final UUID pack, final ResourcePackCallback cb, final ClientAudience audience) {
    if (CALLBACKS.put(pack, new PackCallback(cb, audience)) != null) {
      LOGGER.warn("Duplicate client resource pack callbacks registered for pack {}", pack);
    }
  }

  public ListeningPackFeedbackWrapper(final class_9039 delegate) {
    this.delegate = delegate;
  }

  @Override
  public void method_55620(final UUID packId, final class_9060 status) {
    final PackCallback cb = CALLBACKS.get(packId);
    if (cb != null) {
      final ResourcePackStatus advStatus = switch (status) {
        case field_47699 -> ResourcePackStatus.ACCEPTED;
        case field_47700 -> ResourcePackStatus.DOWNLOADED;
      };
      cb.cb().packEventReceived(packId, advStatus, cb.listener());
      return; // we have a clientside pack, handle it ourselves rather than sending to server
    }
    this.delegate.method_55620(packId, status);
  }

  @Override
  public void method_55619(final UUID packId, final class_9040 status) {
    final PackCallback cb = CALLBACKS.remove(packId);
    if (cb != null) {
      final ResourcePackStatus advStatus = switch (status) {
        case field_47623 -> ResourcePackStatus.DECLINED;
        case field_47624 -> ResourcePackStatus.SUCCESSFULLY_LOADED;
        case field_47625 -> ResourcePackStatus.DISCARDED;
        case field_47626 -> ResourcePackStatus.FAILED_DOWNLOAD;
        case field_47627 -> ResourcePackStatus.FAILED_RELOAD;
      };

      cb.cb().packEventReceived(packId, advStatus, cb.listener());
      return; // we have a clientside pack, handle it ourselves rather than sending to server
    }
    this.delegate.method_55619(packId, status);
  }
}
