/*
 * This file is part of adventure-platform-fabric, licensed under the MIT License.
 *
 * Copyright (c) 2020-2023 KyoriPowered
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package net.kyori.adventure.platform.fabric.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.resource.ResourcePackStatus;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.util.Index;
import net.minecraft.class_1259;
import net.minecraft.class_2856;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public final class GameEnums {
  public static final MappedRegistry<class_1259.class_1260, BossBar.Color> BOSS_BAR_COLOR = MappedRegistry.named(
    class_1259.class_1260.class,
    class_1259.class_1260::method_5422,
    BossBar.Color.class,
    BossBar.Color.NAMES
  );

  public static final MappedRegistry<class_1259.class_1261, BossBar.Overlay> BOSS_BAR_OVERLAY = MappedRegistry.named(
    class_1259.class_1261.class,
    class_1259.class_1261::method_5424,
    BossBar.Overlay.class,
    BossBar.Overlay.NAMES
  );

  public static final MappedRegistry<class_3419, Sound.Source> SOUND_SOURCE = MappedRegistry.named(
    class_3419.class,
    byNameProvider(class_3419.class, class_3419::method_14840),
    Sound.Source.class,
    Sound.Source.NAMES
  );

  public static final MappedRegistry<class_2856.class_2857, ResourcePackStatus> RESOURCE_PACK_STATUS = MappedRegistry.named(
    class_2856.class_2857.class,
    byNameProvider(class_2856.class_2857.class, class_2856.class_2857::name),
    ResourcePackStatus.class,
    Index.create(ResourcePackStatus.class, ResourcePackStatus::name)
  );

  private static <E extends Enum<E>> Function<String, @Nullable E> byNameProvider(final Class<E> clazz, final Function<E, String> nameProvider) {
    final Map<String, E> sources = new HashMap<>();
    for (final E element : clazz.getEnumConstants()) {
      sources.put(nameProvider.apply(element), element);
    }

    return sources::get;
  }

  private GameEnums() {
  }
}
