/*
 * This file is part of adventure-platform-fabric, licensed under the MIT License.
 *
 * Copyright (c) 2020-2024 KyoriPowered
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package net.kyori.adventure.platform.fabric.impl;

import com.google.common.base.Suppliers;
import com.google.gson.JsonParseException;
import com.mojang.serialization.JsonOps;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.class_8824;
import org.jetbrains.annotations.NotNull;

public final class NonWrappingComponentSerializer implements ComponentSerializer<Component, Component, net.minecraft.class_2561> {
  public static final NonWrappingComponentSerializer INSTANCE = new NonWrappingComponentSerializer();

  private static final ThreadLocal<Boolean> BYPASS_IS_ALLOWED_FROM_SERVER = ThreadLocal.withInitial(() -> false);
  private final Supplier<class_7225.@NotNull class_7874> holderProvider;

  private NonWrappingComponentSerializer() {
    this(Suppliers.ofInstance(class_5455.method_40302(class_7923.field_41167)));
  }

  public NonWrappingComponentSerializer(final @NotNull Supplier<class_7225.@NotNull class_7874> provider) {
    this.holderProvider = provider;
  }

  public static boolean bypassIsAllowedFromServer() {
    return BYPASS_IS_ALLOWED_FROM_SERVER.get();
  }

  @Override
  public Component deserialize(final net.minecraft.class_2561 input) {
    if (input instanceof WrappedComponent) {
      return ((WrappedComponent) input).wrapped();
    }

    return GsonComponentSerializer.gson().deserializeFromTree(
      class_8824.field_46597.encodeStart(this.holderProvider.get().method_57093(JsonOps.INSTANCE), input)
        .getOrThrow(JsonParseException::new)
    );
  }

  @Override
  public class_5250 serialize(final Component component) {
    BYPASS_IS_ALLOWED_FROM_SERVER.set(true);
    final class_5250 mutableComponent;
    try {
      mutableComponent = net.minecraft.class_2561.class_2562.method_10872(GsonComponentSerializer.gson().serializeToTree(component), this.holderProvider.get());
    } finally {
      BYPASS_IS_ALLOWED_FROM_SERVER.set(false);
    }
    return mutableComponent;
  }
}
