/*
 * This file is part of adventure-platform-fabric, licensed under the MIT License.
 *
 * Copyright (c) 2022-2024 KyoriPowered
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package net.kyori.adventure.platform.fabric.impl;

import java.util.HashSet;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

/**
 * A packet sent client to server, to let the server know which optional argument types are available on the server.
 *
 * <p>This packet is sent by players on join, before the command tree is sent to the client.</p>
 *
 * @param known Known argument type ids
 */
public record ServerboundRegisteredArgumentTypesPacket(Set<class_2960> known) implements class_8710 {
  public static final class_8710.class_9154<ServerboundRegisteredArgumentTypesPacket> TYPE = new class_8710.class_9154<>(AdventureCommon.res("registered_args"));
  private static final class_9139<class_9129, ServerboundRegisteredArgumentTypesPacket> CODEC = class_9139.method_56434(
    class_9135.method_56376(HashSet::new, class_2960.field_48267),
    ServerboundRegisteredArgumentTypesPacket::known,
    ServerboundRegisteredArgumentTypesPacket::new
  );

  public static void register() {
    PayloadTypeRegistry.playC2S().register(TYPE, CODEC);
    ServerPlayNetworking.registerGlobalReceiver(TYPE, (pkt, ctx) -> {
      ctx.player().method_5682().execute(() -> { // on main thread
        ServerArgumentTypes.knownArgumentTypes(ctx.player(), pkt.known, ctx.responseSender());
      });
    });
  }

  public static ServerboundRegisteredArgumentTypesPacket of(final Set<class_2960> idents) {
    return new ServerboundRegisteredArgumentTypesPacket(Set.copyOf(idents));
  }

  /**
   * Send the client's list of identifiers to the server.
   *
   * @param sender the sender to send the packet to
   */
  public void sendTo(final PacketSender sender) {
    sender.sendPacket(this);
  }

  @Override
  public @NotNull class_9154<? extends class_8710> method_56479() {
    return TYPE;
  }
}
