/*
 * This file is part of adventure-platform-fabric, licensed under the MIT License.
 *
 * Copyright (c) 2020-2024 KyoriPowered
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package net.kyori.adventure.platform.fabric.impl;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.kyori.adventure.platform.fabric.FabricAudiences;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.renderer.ComponentRenderer;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_7417;
import net.minecraft.class_8828;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrappedComponent implements class_2561 {
  protected class_2561 converted;
  protected @Nullable Object deepConvertedLocalized = null;
  private final net.kyori.adventure.text.Component wrapped;
  private final @Nullable Function<Pointered, ?> partition;
  private final @Nullable ComponentRenderer<Pointered> renderer;
  private final @Nullable NonWrappingComponentSerializer nonWrappingSerializer;
  private @Nullable Object lastData;
  private @Nullable WrappedComponent lastRendered;

  public WrappedComponent(
    final net.kyori.adventure.text.Component wrapped,
    final @Nullable Function<Pointered, ?> partition,
    final @Nullable ComponentRenderer<Pointered> renderer,
    final @Nullable NonWrappingComponentSerializer nonWrappingComponentSerializer
  ) {
    this.wrapped = wrapped;
    this.partition = partition;
    this.renderer = renderer;
    this.nonWrappingSerializer = nonWrappingComponentSerializer;
  }

  /**
   * Renderer to use to translate messages.
   *
   * @return the renderer, if any
   */
  public @Nullable ComponentRenderer<Pointered> renderer() {
    return this.renderer;
  }

  /**
   * Partition to use to generate cache keys.
   *
   * @return the partition, if any
   */
  public @Nullable Function<Pointered, ?> partition() {
    return this.partition;
  }

  public net.kyori.adventure.text.Component wrapped() {
    return this.wrapped;
  }

  public synchronized WrappedComponent rendered(final Pointered ptr) {
    final Object data = this.partition == null ? null : this.partition.apply(ptr);
    if (this.lastData != null && Objects.equals(data, this.lastData)) {
      return this.lastRendered;
    }
    this.lastData = data;
    return this.lastRendered = this.renderer == null ? this : AdventureCommon.SIDE_PROXY.createWrappedComponent(this.renderer.render(this.wrapped, ptr), null, null, this.nonWrappingSerializer);
  }

  public class_2561 deepConverted() {
    class_2561 converted = this.converted;
    if (converted == null || this.deepConvertedLocalized != null) {
      ComponentSerializer<net.kyori.adventure.text.Component, net.kyori.adventure.text.Component, class_2561> serializer = this.nonWrappingSerializer;
      if (serializer == null) {
        serializer = FabricAudiences.nonWrappingSerializer();
      }
      converted = this.converted = serializer.serialize(this.wrapped);
      this.deepConvertedLocalized = null;
    }
    return converted;
  }

  @ApiStatus.OverrideOnly
  protected class_2561 deepConvertedLocalized() {
    return this.deepConverted();
  }

  public @Nullable class_2561 deepConvertedIfPresent() {
    return this.converted;
  }

  @Override
  public class_2583 method_10866() {
    return this.deepConverted().method_10866();
  }

  @Override
  public String getString() {
    return PlainTextComponentSerializer.plainText().serialize(this.rendered(AdventureCommon.pointered(Pointers::empty)).wrapped);
  }

  @Override
  public String method_10858(final int length) {
    return this.deepConverted().method_10858(length);
  }

  @Override
  public class_7417 method_10851() {
    if (this.wrapped instanceof TextComponent text) {
      return new class_8828.class_2585(text.content());
    } else {
      return this.deepConverted().method_10851();
    }
  }

  @Override
  public List<class_2561> method_10855() {
    return this.deepConverted().method_10855();
  }

  @Override
  public class_5250 method_27662() {
    return this.deepConverted().method_27662();
  }

  @Override
  public class_5250 method_27661() {
    return this.deepConverted().method_27661();
  }

  @Override
  public class_5481 method_30937() {
    return this.deepConvertedLocalized().method_30937();
  }

  @Override
  public <T> Optional<T> method_27658(final class_5246<T> visitor, final class_2583 style) {
    return this.deepConvertedLocalized().method_27658(visitor, style);
  }

  @Override
  public <T> Optional<T> method_27657(final class_5245<T> visitor) {
    return this.deepConverted().method_27657(visitor);
  }

  @Override
  public net.kyori.adventure.text.@NotNull Component asComponent() {
    return this.wrapped;
  }
}
