/*
 * This file is part of adventure-platform-fabric, licensed under the MIT License.
 *
 * Copyright (c) 2020-2022 KyoriPowered
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package net.kyori.adventure.platform.fabric.impl.client;

import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.platform.fabric.impl.AbstractBossBarListener;
import net.minecraft.class_2561;
import net.minecraft.class_345;
import org.jetbrains.annotations.NotNull;

public class ClientBossBarListener extends AbstractBossBarListener<class_345> {
  private final Map<UUID, class_345> hudBars;

  public ClientBossBarListener(final FabricClientAudiencesImpl controller, final Map<UUID, class_345> hudBars) {
    super(controller);
    this.hudBars = hudBars;
  }

  @Override
  protected class_345 newBar(final @NotNull class_2561 title,
                                    final class_1259.@NotNull class_1260 color,
                                    final class_1259.@NotNull class_1261 style,
                                    final float progress) {
    return new class_345(UUID.randomUUID(), title, progress, color, style, false, false, false);
  }

  public void add(final BossBar bar) {
    final class_345 mc = this.minecraftCreating(bar);
    this.hudBars.put(mc.method_5407(), mc);
  }

  public void remove(final BossBar bar) {
    final class_345 mc = this.bars.remove(bar);
    if (mc != null) {
      bar.removeListener(this);
      this.hudBars.remove(mc.method_5407());
    }
  }

  public void clear() {
    for (final Map.Entry<BossBar, class_345> entry : this.bars.entrySet()) {
      entry.getKey().removeListener(this);
      this.hudBars.remove(entry.getValue().method_5407());
    }
    this.bars.clear();
  }
}
