/*
 * This file is part of adventure-platform-fabric, licensed under the MIT License.
 *
 * Copyright (c) 2020-2022 KyoriPowered
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package net.kyori.adventure.platform.fabric.impl.mixin.minecraft.commands.synchronization;

import net.kyori.adventure.platform.fabric.impl.ServerArgumentTypes;
import net.minecraft.class_2314;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7218;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(class_7218.class)
public abstract class ArgumentUtilsMixin {
  @Redirect(
    method = "serializeArgumentToJson(Lcom/google/gson/JsonObject;Lcom/mojang/brigadier/arguments/ArgumentType;)V",
    at = @At(value = "INVOKE", target = "Lnet/minecraft/core/Registry;getKey(Ljava/lang/Object;)Lnet/minecraft/resources/ResourceLocation;")
  )
  @SuppressWarnings({"rawtypes", "unchecked"})
  private static @Nullable class_2960 redirectArgumentName(final class_2378 registry, final Object argumentTypeInfo) {
    if (ServerArgumentTypes.isServerType((class_2314<?, ?>) argumentTypeInfo)) {
      return ServerArgumentTypes.serverType((class_2314<?, ?>) argumentTypeInfo).id();
    }
    return registry.method_10221(argumentTypeInfo);
  }
}
