/*
 * This file is part of adventure-platform-fabric, licensed under the MIT License.
 *
 * Copyright (c) 2022 KyoriPowered
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package net.kyori.adventure.platform.fabric.impl.mixin.minecraft.network.chat;

import java.time.Instant;
import java.util.stream.Stream;
import net.kyori.adventure.chat.SignedMessage;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.examination.ExaminableProperty;
import net.minecraft.class_7469;
import net.minecraft.class_7471;
import net.minecraft.class_7608;
import net.minecraft.class_7649;
import net.minecraft.class_7826;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Implements(@Interface(iface = SignedMessage.class, prefix = "signedMessage$"))
@Mixin(class_7471.class)
public abstract class PlayerChatMessageMixin implements SignedMessage {

  // @formatter:off
  @Shadow public abstract class_7469 shadow$signature();
  @Shadow public abstract net.minecraft.@Nullable class_2561 shadow$unsignedContent();
  @Shadow public abstract class_7608 shadow$signedBody();
  @Shadow public abstract class_7826 shadow$link();
  @Shadow public abstract boolean shadow$isSystem();

  @Shadow @Final private class_7826 link;
  @Shadow @Final private class_7469 signature;
  @Shadow @Final private class_7608 signedBody;
  @Shadow @Final private net.minecraft.@Nullable class_2561 unsignedContent;
  @Shadow @Final private class_7649 filterMask;
  // @formatter:on

  @Override
  public @NotNull Identity identity() {
    return this.shadow$isSystem() ? Identity.nil() : Identity.identity(this.shadow$link().comp_1095());
  }

  @Override
  public @NotNull Instant timestamp() {
    return this.shadow$signedBody().comp_930();
  }

  @Override
  public long salt() {
    return this.shadow$signedBody().comp_931();
  }

  @Override
  public @Nullable Signature signature() {
    return this.shadow$signature();
  }

  @Override
  public @Nullable Component unsignedContent() {
    return ComponentLike.unbox(this.shadow$unsignedContent());
  }

  @Override
  public @NotNull String message() {
    return this.shadow$signedBody().comp_929();
  }

  @Intrinsic
  public boolean signedMessage$isSystem() {
    return this.shadow$isSystem();
  }

  @Override
  public boolean canDelete() {
    return this.shadow$signature() != null;
  }

  @Override
  public @NotNull Stream<? extends ExaminableProperty> examinableProperties() {
    return Stream.of(
      ExaminableProperty.of("link", this.link),
      ExaminableProperty.of("signature", this.signature),
      ExaminableProperty.of("signedBody", this.signedBody),
      ExaminableProperty.of("unsignedContent", this.unsignedContent),
      ExaminableProperty.of("filterMask", this.filterMask)
    );
  }
}
