/*
 * This file is part of adventure-platform-fabric, licensed under the MIT License.
 *
 * Copyright (c) 2020-2024 KyoriPowered
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package net.kyori.adventure.platform.fabric.impl.mixin.minecraft.server.level;

import com.google.common.collect.MapMaker;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.platform.fabric.FabricServerAudiences;
import net.kyori.adventure.platform.fabric.PlayerLocales;
import net.kyori.adventure.platform.fabric.impl.ControlledAudience;
import net.kyori.adventure.platform.fabric.impl.FabricAudiencesInternal;
import net.kyori.adventure.platform.fabric.impl.LocaleHolderBridge;
import net.kyori.adventure.platform.fabric.impl.mixin.minecraft.world.entity.player.PlayerMixin;
import net.kyori.adventure.platform.fabric.impl.server.FabricServerAudiencesImpl;
import net.kyori.adventure.platform.fabric.impl.server.RenderableAudience;
import net.kyori.adventure.platform.fabric.impl.server.ServerPlayerAudience;
import net.kyori.adventure.platform.fabric.impl.server.ServerPlayerBridge;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2772;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8791;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3222.class)
public abstract class ServerPlayerMixin extends PlayerMixin implements ForwardingAudience.Single, LocaleHolderBridge, RenderableAudience, ServerPlayerBridge, ControlledAudience {
  // @formatter:off
  @Shadow @Final public MinecraftServer server;
  @Shadow public class_3244 connection;
  // @formatter:on

  private Audience adventure$backing;
  private Locale adventure$locale;
  private final Map<FabricServerAudiencesImpl, Audience> adventure$renderers = new MapMaker().weakKeys().makeMap();
  private class_2561 adventure$tabListHeader = class_2561.method_43473();
  private class_2561 adventure$tabListFooter = class_2561.method_43473();
  private Set<class_2960> adventure$arguments = Set.of();

  protected ServerPlayerMixin(final class_1299<? extends class_1309> entityType, final class_1937 level) {
    super(entityType, level);
  }

  @Inject(method = "<init>", at = @At("TAIL"))
  private void adventure$init(final CallbackInfo ci) {
    this.adventure$backing = FabricServerAudiences.of(this.server).audience(this);
  }

  @Override
  public @NotNull Audience audience() {
    return this.adventure$backing;
  }

  @Override
  public Audience renderUsing(final FabricServerAudiencesImpl controller) {
    return this.adventure$renderers.computeIfAbsent(controller, ctrl -> new ServerPlayerAudience((class_3222) (Object) this, ctrl));
  }

  @Override
  public @NotNull Locale adventure$locale() {
    return this.adventure$locale;
  }

  @Override
  public @NotNull FabricAudiencesInternal controller() {
    return (FabricAudiencesInternal) FabricServerAudiences.of(this.server);
  }

  // Tab list

  @Override
  public void bridge$updateTabList(final @Nullable class_2561 header, final @Nullable class_2561 footer) {
    if (header != null) {
      this.adventure$tabListHeader = header;
    }
    if (footer != null) {
      this.adventure$tabListFooter = footer;
    }
    final class_2772 packet = new class_2772(
      this.adventure$tabListHeader,
      this.adventure$tabListFooter
    );

    this.connection.method_14364(packet);
  }


  // Locale tracking

  @Inject(method = "updateOptions", at = @At("HEAD"))
  private void adventure$handleLocaleUpdate(final class_8791 information, final CallbackInfo ci) {
    final String language = information.comp_1951();
    final @Nullable Locale locale = LocaleHolderBridge.toLocale(language);
    if (!Objects.equals(this.adventure$locale, locale)) {
      this.adventure$locale = locale;
      PlayerLocales.CHANGED_EVENT.invoker().onLocaleChanged((class_3222) (Object) this, locale);
    }
  }

  // Player tracking for boss bars and rendering

  @Inject(method = "restoreFrom", at = @At("RETURN"))
  private void copyData(final class_3222 old, final boolean alive, final CallbackInfo ci) {
    FabricServerAudiencesImpl.forEachInstance(controller -> controller.bossBars().replacePlayer(old, (class_3222) (Object) this));
  }

  @Inject(method = "disconnect", at = @At("RETURN"))
  private void adventure$removeBossBarsOnDisconnect(final CallbackInfo ci) {
    FabricServerAudiencesImpl.forEachInstance(controller -> controller.bossBars().unsubscribeFromAll((class_3222) (Object) this));
  }

  // Known argument type tracking

  @Override
  public Set<class_2960> bridge$knownArguments() {
    return this.adventure$arguments;
  }

  @Override
  public void bridge$knownArguments(final Set<class_2960> arguments) {
    this.adventure$arguments = Set.copyOf(arguments);
  }

  @Inject(method = "restoreFrom", at = @At("RETURN"))
  public void adventure$copyData(final class_3222 from, final boolean keepEverything, final CallbackInfo ci) {
    this.bridge$knownArguments(((ServerPlayerBridge) from).bridge$knownArguments());
  }
}
