/*
 * This file is part of adventure-platform-fabric, licensed under the MIT License.
 *
 * Copyright (c) 2020-2024 KyoriPowered
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package net.kyori.adventure.platform.fabric.impl.mixin.minecraft.world.item;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.platform.fabric.impl.nbt.FabricDataComponentValue;
import net.kyori.adventure.text.event.DataComponentValue;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_7923;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(class_1799.class)
public abstract class ItemStackMixin implements HoverEventSource<HoverEvent.ShowItem> {
  // @formatter:off
  @Shadow public abstract int shadow$getCount();
  @Shadow public abstract class_1792 shadow$getItem();
  @Shadow public abstract class_9326 shadow$getComponentsPatch();
  // @formatter:on

  @Override
  public @NotNull HoverEvent<HoverEvent.ShowItem> asHoverEvent(final @NotNull UnaryOperator<HoverEvent.ShowItem> op) {
    final Key itemType = class_7923.field_41178.method_10221(this.shadow$getItem());
    final Map<Key, DataComponentValue> components;
    final class_9326 patch = this.shadow$getComponentsPatch();
    if (patch.method_57848()) {
      components = Collections.emptyMap();
    } else {
      components = new HashMap<>();
      for (final Map.Entry<class_9331<?>, Optional<?>> entry : patch.method_57846()) {
        if (entry.getKey().method_57877()) continue;

        final Key componentKey = class_7923.field_49658.method_10221(entry.getKey());
        if (entry.getValue().isEmpty()) {
          components.put(componentKey, FabricDataComponentValue.Removed.INSTANCE);
        } else {
          @SuppressWarnings({"rawtypes", "unchecked"}) final FabricDataComponentValue.Present<?> holder = new FabricDataComponentValue.Present(entry.getValue().orElse(null), entry.getKey().method_57876());
          components.put(componentKey, holder);
        }
      }
    }

    final HoverEvent.ShowItem item = HoverEvent.ShowItem.showItem(itemType, this.shadow$getCount(), components);
    return HoverEvent.showItem(op.apply(item));
  }

}
