/*
 * This file is part of adventure-platform-fabric, licensed under the MIT License.
 *
 * Copyright (c) 2020-2021 KyoriPowered
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package net.kyori.adventure.platform.fabric.impl.server;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.platform.fabric.FabricAudiences;
import net.kyori.adventure.platform.fabric.impl.AbstractBossBarListener;
import net.minecraft.class_2561;
import net.minecraft.class_2629;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

import static java.util.Objects.requireNonNull;

public class ServerBossBarListener extends AbstractBossBarListener<class_3213> {
  public ServerBossBarListener(final FabricAudiences controller) {
    super(controller);
  }

  public void subscribe(final class_3222 player, final BossBar bar) {
    this.minecraftCreating(requireNonNull(bar, "bar")).method_14088(requireNonNull(player, "player"));
  }

  public void subscribeAll(final Collection<class_3222> players, final BossBar bar) {
    ((ServerBossEventBridge) this.minecraftCreating(requireNonNull(bar, "bar"))).adventure$addAll(players);
  }

  public void unsubscribe(final class_3222 player, final BossBar bar) {
    this.bars.computeIfPresent(bar, (key, old) -> {
      old.method_14089(player);
      if (old.method_14092().isEmpty()) {
        key.removeListener(this);
        return null;
      } else {
        return old;
      }
    });
  }

  public void unsubscribeAll(final Collection<class_3222> players, final BossBar bar) {
    this.bars.computeIfPresent(bar, (key, old) -> {
      ((ServerBossEventBridge) old).adventure$removeAll(players);
      if (old.method_14092().isEmpty()) {
        key.removeListener(this);
        return null;
      } else {
        return old;
      }
    });
  }

  /**
   * Replace a player entity without sending any packets.
   *
   * <p>This should be triggered when the entity representing a player changes
   * (such as during a respawn)</p>
   *
   * @param old old player
   * @param newPlayer new one
   */
  public void replacePlayer(final class_3222 old, final class_3222 newPlayer) {
    for (final class_3213 bar : this.bars.values()) {
      ((ServerBossEventBridge) bar).adventure$replaceSubscriber(old, newPlayer);
    }
  }

  /**
   * Refresh titles when a player's locale has changed.
   *
   * @param player player to refresh titles fro
   */
  public void refreshTitles(final class_3222 player) {
    for (final class_3213 bar : this.bars.values()) {
      if (bar.method_14092().contains(player)) {
        player.field_13987.method_14364(class_2629.method_34096(bar));
      }
    }
  }

  /**
   * Remove the player from all associated boss bars.
   *
   * @param player The player to remove
   */
  public void unsubscribeFromAll(final class_3222 player) {
    for (final Iterator<Map.Entry<BossBar, class_3213>> it = this.bars.entrySet().iterator(); it.hasNext();) {
      final class_3213 bar = it.next().getValue();
      if (bar.method_14092().contains(player)) {
        bar.method_14089(player);
        if (bar.method_14092().isEmpty()) {
          it.remove();
        }
      }
    }
  }

  @Override
  protected class_3213 newBar(
    final @NotNull class_2561 title,
    final net.minecraft.class_1259.@NotNull class_1260 color,
    final net.minecraft.class_1259.@NotNull class_1261 style,
    final float progress
  ) {
    final class_3213 event = new class_3213(title, color, style);
    event.method_5408(progress);
    return event;
  }
}
